/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.namingserver.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Pattern;
import org.apache.seata.common.metadata.ClusterRole;
import org.apache.seata.common.metadata.Node;
import org.apache.seata.common.metadata.namingserver.NamingServerNode;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.namingserver.filter.CachedBodyHttpServletRequest;
import org.apache.seata.namingserver.manager.NamingManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class ConsoleRemotingFilter
implements Filter {
    private final NamingManager namingManager;
    private final RestTemplate restTemplate;
    private final Pattern urlPattern = Pattern.compile("^/api/.*/console/.*");
    private final Logger logger = LoggerFactory.getLogger(ConsoleRemotingFilter.class);

    public ConsoleRemotingFilter(NamingManager namingManager, RestTemplate restTemplate) {
        this.namingManager = namingManager;
        this.restTemplate = restTemplate;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (servletRequest instanceof HttpServletRequest && this.urlPattern.matcher(((HttpServletRequest)servletRequest).getRequestURI()).matches()) {
            CachedBodyHttpServletRequest request = new CachedBodyHttpServletRequest((HttpServletRequest)servletRequest);
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            String namespace = request.getHeader("x-seata-namespace");
            String cluster = request.getHeader("x-seata-cluster");
            String vgroup = request.getParameter("vgroup");
            if (StringUtils.isNotBlank((String)namespace) && (StringUtils.isNotBlank((String)cluster) || StringUtils.isNotBlank((String)vgroup))) {
                NamingServerNode node;
                Node.Endpoint controlEndpoint;
                List list = null;
                if (StringUtils.isNotBlank((String)vgroup)) {
                    list = this.namingManager.getInstancesByVgroupAndNamespace(namespace, vgroup, StringUtils.equalsIgnoreCase((String)request.getMethod(), (String)HttpMethod.GET.name()));
                } else if (StringUtils.isNotBlank((String)cluster)) {
                    list = this.namingManager.getInstances(namespace, cluster);
                }
                if (CollectionUtils.isNotEmpty(list) && (controlEndpoint = (node = (NamingServerNode)list.get(ThreadLocalRandom.current().nextInt(list.size()))).getControl()) != null) {
                    HttpMethod httpMethod;
                    String targetUrl = "http://" + controlEndpoint.getHost() + ":" + controlEndpoint.getPort() + request.getRequestURI() + (String)(request.getQueryString() != null ? "?" + request.getQueryString() : "");
                    HttpHeaders headers = new HttpHeaders();
                    if (node.getRole() == ClusterRole.LEADER) {
                        headers.add("X-SEATA-RAFT-GROUP", node.getUnit());
                    }
                    Collections.list(request.getHeaderNames()).forEach(headerName -> headers.add(headerName, request.getHeader(headerName)));
                    HttpEntity httpEntity = new HttpEntity((Object)request.getCachedBody(), (MultiValueMap)headers);
                    try {
                        httpMethod = HttpMethod.valueOf((String)request.getMethod());
                    }
                    catch (IllegalArgumentException ex) {
                        this.logger.error("Unsupported HTTP method: {}", (Object)request.getMethod(), (Object)ex);
                        response.setStatus(405);
                        return;
                    }
                    try {
                        ResponseEntity responseEntity = this.restTemplate.exchange(URI.create(targetUrl), httpMethod, httpEntity, byte[].class);
                        responseEntity.getHeaders().forEach((key, value) -> value.forEach(v -> response.addHeader(key, v)));
                        response.setStatus(responseEntity.getStatusCode().value());
                        Optional.ofNullable((byte[])responseEntity.getBody()).ifPresent(body -> {
                            try (ServletOutputStream outputStream = response.getOutputStream();){
                                outputStream.write(body);
                                outputStream.flush();
                            }
                            catch (IOException e) {
                                this.logger.error(e.getMessage(), (Throwable)e);
                            }
                        });
                    }
                    catch (Exception ex) {
                        this.logger.error(ex.getMessage(), (Throwable)ex);
                        response.sendError(500);
                    }
                    return;
                }
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }
}

