/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.writer.ObjectWriterPrimitiveImpl;
import java.lang.reflect.Type;

final class ObjectWriterImplInt64Array
extends ObjectWriterPrimitiveImpl {
    static final ObjectWriterImplInt64Array INSTANCE = new ObjectWriterImplInt64Array();
    static final byte[] JSONB_TYPE_NAME_BYTES = JSONB.toBytes("[Long");
    static final long JSONB_TYPE_HASH = Fnv.hashCode64("[Long");

    ObjectWriterImplInt64Array() {
    }

    @Override
    public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        if (object == null) {
            if (jsonWriter.isEnabled(JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullListAsEmpty.mask)) {
                jsonWriter.startArray();
                jsonWriter.endArray();
            } else {
                jsonWriter.writeNull();
            }
            return;
        }
        boolean writeAsString = (features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L;
        Long[] array = (Long[])object;
        jsonWriter.startArray();
        for (int i = 0; i < array.length; ++i) {
            Long item;
            if (i != 0) {
                jsonWriter.writeComma();
            }
            if ((item = array[i]) == null) {
                jsonWriter.writeNull();
                continue;
            }
            long longValue = item;
            if (writeAsString) {
                jsonWriter.writeString(longValue);
                continue;
            }
            jsonWriter.writeInt64(longValue);
        }
        jsonWriter.endArray();
    }

    @Override
    public void writeJSONB(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        if (object == null) {
            jsonWriter.writeNull();
            return;
        }
        if (jsonWriter.isWriteTypeInfo(object, fieldType)) {
            jsonWriter.writeTypeName(JSONB_TYPE_NAME_BYTES, JSONB_TYPE_HASH);
        }
        boolean writeAsString = (features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L;
        Long[] array = (Long[])object;
        jsonWriter.startArray(array.length);
        for (Long item : array) {
            if (item == null) {
                jsonWriter.writeNull();
                continue;
            }
            long longValue = item;
            if (writeAsString) {
                jsonWriter.writeString(longValue);
                continue;
            }
            jsonWriter.writeInt64(longValue);
        }
    }
}

