/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer.scala;

import java.lang.reflect.Field;
import org.apache.fory.Fory;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.memory.Platform;
import org.apache.fory.serializer.Serializer;
import org.apache.fory.util.GraalvmSupport;
import org.apache.fory.util.Preconditions;

public class SingletonObjectSerializer
extends Serializer {
    private final Field field;
    private Object base = null;
    private long offset = -1L;

    public SingletonObjectSerializer(Fory fory, Class type) {
        super(fory, type);
        try {
            Class.forName(type.getName(), true, type.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        try {
            this.field = type.getDeclaredField("MODULE$");
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(type + " doesn't have `MODULE$` field", e);
        }
    }

    public void write(MemoryBuffer buffer, Object value) {
    }

    public Object read(MemoryBuffer buffer) {
        long offset = this.offset;
        if (offset == -1L) {
            Preconditions.checkArgument(!GraalvmSupport.isGraalBuildtime());
            offset = this.offset = Platform.UNSAFE.staticFieldOffset(this.field);
            this.base = Platform.UNSAFE.staticFieldBase(this.field);
        }
        return Platform.getObject(this.base, offset);
    }
}

