/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.hive.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLListExpr;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLConstraint;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLExternalRecordFormat;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLTableElement;
import com.alibaba.druid.sql.dialect.hive.ast.HiveInputOutputFormat;
import com.alibaba.druid.sql.dialect.hive.parser.HiveExprParser;
import com.alibaba.druid.sql.dialect.hive.parser.HiveSelectParser;
import com.alibaba.druid.sql.dialect.hive.stmt.HiveCreateTableStatement;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLCreateTableParser;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLSelectParser;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;

public class HiveCreateTableParser
extends SQLCreateTableParser {
    public HiveCreateTableParser(SQLExprParser exprParser) {
        super(exprParser);
    }

    public HiveCreateTableParser(Lexer lexer) {
        super(new HiveExprParser(lexer));
    }

    @Override
    protected void createTableBefore(SQLCreateTableStatement stmt) {
        if (this.lexer.nextIfIdentifier(FnvHash.Constants.EXTERNAL)) {
            stmt.setExternal(true);
        }
        if (this.lexer.nextIfIdentifier(FnvHash.Constants.TEMPORARY)) {
            stmt.setTemporary(true);
        }
        if (this.lexer.nextIfIdentifier("TRANSACTIONAL")) {
            stmt.config(SQLCreateTableStatement.Feature.Transactional);
        }
    }

    @Override
    protected void createTableBody(SQLCreateTableStatement stmt) {
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            do {
                SQLColumnDefinition column;
                Token token;
                if ((token = this.lexer.token()) == Token.IDENTIFIER || token == Token.LITERAL_ALIAS) {
                    column = this.exprParser.parseColumn();
                    stmt.getTableElementList().add(column);
                } else if (token == Token.PRIMARY || token == Token.UNIQUE || token == Token.CHECK || token == Token.CONSTRAINT || token == Token.FOREIGN) {
                    SQLConstraint constraint = this.exprParser.parseConstraint();
                    constraint.setParent(stmt);
                    stmt.getTableElementList().add((SQLTableElement)((Object)constraint));
                } else {
                    if (token == Token.TABLESPACE) {
                        throw new ParserException("TODO " + this.lexer.info());
                    }
                    column = this.exprParser.parseColumn();
                    stmt.getTableElementList().add(column);
                }
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            } while (this.lexer.token() != Token.RPAREN);
            this.accept(Token.RPAREN);
        } else if (this.lexer.token() == Token.LIKE) {
            this.parseLike((HiveCreateTableStatement)stmt);
        }
    }

    @Override
    protected void createTableQuery(SQLCreateTableStatement stmt) {
        if (this.lexer.token() == Token.SELECT || this.lexer.token() == Token.AS) {
            if (this.lexer.token() == Token.AS) {
                this.lexer.nextToken();
            }
            SQLSelect select = this.createSQLSelectParser().select();
            stmt.setSelect(select);
        }
    }

    protected void parseCreateTableWithSerderPropertie(HiveCreateTableStatement stmt) {
        if (this.lexer.token() == Token.WITH) {
            this.lexer.nextToken();
            this.acceptIdentifier("SERDEPROPERTIES");
            this.accept(Token.LPAREN);
            while (true) {
                String key = this.lexer.stringVal();
                this.lexer.nextToken();
                this.accept(Token.EQ);
                SQLExpr value = this.exprParser.primary();
                stmt.getSerdeProperties().put(key, value);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
    }

    @Override
    protected void parseCreateTableRest(SQLCreateTableStatement createTable) {
        SQLExpr comment;
        SQLExpr using;
        HiveCreateTableStatement stmt = (HiveCreateTableStatement)createTable;
        if (this.lexer.nextIfIdentifier(FnvHash.Constants.ENGINE)) {
            this.accept(Token.EQ);
            this.lexer.nextToken();
        }
        if (this.lexer.nextIfIdentifier(FnvHash.Constants.CHARSET)) {
            this.accept(Token.EQ);
            this.lexer.nextToken();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.USING) || this.lexer.token() == Token.USING) {
            this.lexer.nextToken();
            using = this.exprParser.expr();
            stmt.setUsing(using);
        }
        if (this.lexer.nextIfIdentifier(FnvHash.Constants.OPTIONS)) {
            this.accept(Token.LPAREN);
            this.parseAssignItems(stmt.getTableOptions(), stmt, false);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.nextIf(Token.COMMENT)) {
            comment = this.exprParser.expr();
            stmt.setComment(comment);
        }
        if (this.lexer.nextIfIdentifier(FnvHash.Constants.MAPPED)) {
            this.accept(Token.BY);
            this.exprParser.parseAssignItem(stmt.getMappedBy(), (SQLObject)stmt);
        }
        if (this.lexer.nextIf(Token.PARTITIONED)) {
            this.accept(Token.BY);
            this.accept(Token.LPAREN);
            while (true) {
                if (this.lexer.token() != Token.IDENTIFIER) {
                    throw new ParserException("expect identifier. " + this.lexer.info());
                }
                SQLColumnDefinition column = this.exprParser.parseColumn();
                stmt.addPartitionColumn(column);
                if (this.lexer.isKeepComments() && this.lexer.hasComment()) {
                    column.addAfterComment(this.lexer.readAndResetComments());
                }
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
                if (!this.lexer.isKeepComments() || !this.lexer.hasComment()) continue;
                column.addAfterComment(this.lexer.readAndResetComments());
            }
            this.accept(Token.RPAREN);
        }
        if (this.lexer.nextIfIdentifier(FnvHash.Constants.CLUSTERED)) {
            this.accept(Token.BY);
            this.accept(Token.LPAREN);
            while (true) {
                SQLSelectOrderByItem item = this.exprParser.parseSelectOrderByItem();
                stmt.addClusteredByItem(item);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.SORTED)) {
            this.parseSortedBy(stmt);
        }
        if (stmt.getClusteredBy().size() > 0 || stmt.getSortedBy().size() > 0) {
            this.accept(Token.INTO);
            if (this.lexer.token() != Token.LITERAL_INT) {
                throw new ParserException("into buckets must be integer. " + this.lexer.info());
            }
            stmt.setBuckets(this.lexer.integerValue().intValue());
            this.lexer.nextToken();
            this.acceptIdentifier("BUCKETS");
        }
        if (this.lexer.nextIfIdentifier(FnvHash.Constants.SKEWED)) {
            this.accept(Token.BY);
            this.accept(Token.LPAREN);
            this.exprParser.exprList(stmt.getSkewedBy(), stmt);
            this.accept(Token.RPAREN);
            this.accept(Token.ON);
            this.accept(Token.LPAREN);
            while (true) {
                if (this.lexer.token() == Token.LPAREN) {
                    SQLListExpr list = new SQLListExpr();
                    this.lexer.nextToken();
                    this.exprParser.exprList(list.getItems(), list);
                    this.accept(Token.RPAREN);
                    stmt.addSkewedByOn(list);
                } else {
                    SQLExpr expr = this.exprParser.expr();
                    stmt.addSkewedByOn(expr);
                }
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
            if (this.lexer.nextIfIdentifier(FnvHash.Constants.STORED)) {
                this.accept(Token.AS);
                this.acceptIdentifier("DIRECTORIES");
                stmt.setSkewedByStoreAsDirectories(true);
            }
        }
        if (this.lexer.token() == Token.ROW || this.lexer.identifierEquals(FnvHash.Constants.ROW)) {
            this.parseRowFormat(stmt);
        }
        if (Token.LBRACKET.equals((Object)this.lexer.token())) {
            stmt.setLbracketUse(true);
            this.lexer.nextToken();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.STORED)) {
            SQLName name;
            this.lexer.nextToken();
            if (this.lexer.token() == Token.BY) {
                this.accept(Token.BY);
                name = this.exprParser.name();
                stmt.setStoredBy(name);
                this.parseCreateTableWithSerderPropertie(stmt);
            } else {
                this.accept(Token.AS);
                if (this.lexer.identifierEquals(FnvHash.Constants.INPUTFORMAT)) {
                    HiveInputOutputFormat format = new HiveInputOutputFormat();
                    this.lexer.nextToken();
                    format.setInput(this.exprParser.primary());
                    if (this.lexer.identifierEquals(FnvHash.Constants.OUTPUTFORMAT)) {
                        this.lexer.nextToken();
                        format.setOutput(this.exprParser.primary());
                    }
                    stmt.setStoredAs(format);
                } else {
                    name = this.exprParser.name();
                    stmt.setStoredAs(name);
                }
            }
        }
        if (Token.RBRACKET.equals((Object)this.lexer.token())) {
            stmt.setRbracketUse(true);
            this.lexer.nextToken();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.LOCATION)) {
            this.lexer.nextToken();
            SQLExpr location = this.exprParser.primary();
            stmt.setLocation(location);
        }
        if (this.lexer.token() == Token.LIKE) {
            this.parseLike(stmt);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.TBLPROPERTIES)) {
            this.parseOptions(stmt);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.META)) {
            this.lexer.nextToken();
            this.acceptIdentifier("LIFECYCLE");
            stmt.setLifeCycle(this.exprParser.primary());
        }
        this.createTableQuery(stmt);
        if (this.lexer.token() == Token.LIKE) {
            this.lexer.nextToken();
            Lexer.SavePoint mark = this.lexer.mark();
            if (this.lexer.token() == Token.SELECT) {
                stmt.setLikeQuery(true);
                SQLSelect select = this.createSQLSelectParser().select();
                stmt.setSelect(select);
            } else {
                this.lexer.reset(mark);
                if (this.lexer.identifierEquals(FnvHash.Constants.MAPPING)) {
                    SQLExpr like = this.exprParser.primary();
                    stmt.setLike(new SQLExprTableSource(like));
                } else {
                    SQLName name = this.exprParser.name();
                    stmt.setLike(name);
                }
            }
        }
        if (this.lexer.token() == Token.COMMENT) {
            this.lexer.nextToken();
            comment = this.exprParser.expr();
            stmt.setComment(comment);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.USING) || this.lexer.token() == Token.USING) {
            this.lexer.nextToken();
            using = this.exprParser.expr();
            stmt.setUsing(using);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.TBLPROPERTIES)) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            this.parseAssignItems(stmt.getTableOptions(), stmt, false);
            this.accept(Token.RPAREN);
        }
    }

    @Override
    protected void parseOptions(SQLCreateTableStatement stmt) {
        this.lexer.nextToken();
        this.accept(Token.LPAREN);
        do {
            String name = this.lexer.stringVal();
            this.lexer.nextToken();
            if (this.lexer.token() == Token.DOT) {
                this.lexer.nextToken();
                name = name + "." + this.lexer.stringVal();
                this.lexer.nextToken();
            }
            this.accept(Token.EQ);
            SQLExpr value = this.exprParser.primary();
            stmt.addOption(name, value);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        } while (this.lexer.token() != Token.RPAREN);
        this.accept(Token.RPAREN);
    }

    protected void parseLike(HiveCreateTableStatement stmt) {
        this.lexer.nextToken();
        if (this.lexer.identifierEquals(FnvHash.Constants.MAPPING)) {
            SQLExpr like = this.exprParser.primary();
            stmt.setLike(new SQLExprTableSource(like));
        } else if (this.lexer.token() == Token.SELECT || this.lexer.token() == Token.LPAREN) {
            SQLSelect select = this.createSQLSelectParser().select();
            stmt.setLikeQuery(true);
            stmt.setSelect(select);
        } else {
            SQLName name = this.exprParser.name();
            stmt.setLike(name);
        }
    }

    protected void parseSortedBy(HiveCreateTableStatement stmt) {
        this.lexer.nextToken();
        this.accept(Token.BY);
        this.accept(Token.LPAREN);
        while (true) {
            SQLSelectOrderByItem item = this.exprParser.parseSelectOrderByItem();
            stmt.addSortedByItem(item);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
    }

    protected void parseRowFormat(HiveCreateTableStatement stmt) {
        SQLExternalRecordFormat format = this.getExprParser().parseRowFormat();
        stmt.setRowFormat(format);
        this.parseCreateTableWithSerderPropertie(stmt);
    }

    @Override
    public HiveExprParser getExprParser() {
        return (HiveExprParser)this.exprParser;
    }

    @Override
    protected HiveCreateTableStatement newCreateStatement() {
        return new HiveCreateTableStatement();
    }

    @Override
    public SQLSelectParser createSQLSelectParser() {
        return new HiveSelectParser(this.exprParser, this.selectListCache);
    }
}

