/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.seata.server.console.service;

import org.apache.seata.common.result.PageResult;
import org.apache.seata.common.result.SingleResult;
import org.apache.seata.server.console.entity.param.GlobalSessionParam;
import org.apache.seata.server.console.entity.vo.GlobalSessionVO;

/**
 * Global session service
 */
public interface GlobalSessionService {

    /**
     * Query global session
     * @param param the param
     * @return the GlobalSessionVO list
     */
    PageResult<GlobalSessionVO> query(GlobalSessionParam param);

    /**
     * Delete the global session
     *
     * @param xid The xid
     * @return SingleResult<Void>
     */
    SingleResult<Void> deleteGlobalSession(String xid);

    /**
     * Force delete the global session
     *
     * @param xid The xid
     * @return SingleResult<Void>
     */
    SingleResult<Void> forceDeleteGlobalSession(String xid);

    /**
     * Stop the global session retry
     *
     * @param xid The xid
     * @return SingleResult<Void>
     */
    SingleResult<Void> stopGlobalRetry(String xid);

    /**
     * Start the global session retry
     *
     * @param xid The xid
     * @return SingleResult<Void>
     */
    SingleResult<Void> startGlobalRetry(String xid);

    /**
     * Send global session to commit or rollback to rm
     *
     * @param xid The xid
     * @return SingleResult<Void>
     */
    SingleResult<Void> sendCommitOrRollback(String xid);

    /**
     * Change the global session status
     *
     * @param xid The xid
     * @return SingleResult<Void>
     */
    SingleResult<Void> changeGlobalStatus(String xid);
}
