/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.util.nio.GridNioDelimitedBuffer;
import org.apache.ignite.internal.util.nio.GridNioParser;
import org.apache.ignite.internal.util.nio.GridNioSession;
import org.apache.ignite.internal.util.nio.GridNioSessionMetaKey;

public class GridDelimitedParser
implements GridNioParser {
    private static final int BUF_META_KEY = GridNioSessionMetaKey.nextUniqueKey();
    private final byte[] delim;
    private final boolean directBuf;

    public GridDelimitedParser(byte[] delim, boolean directBuf) {
        this.delim = delim;
        this.directBuf = directBuf;
    }

    public byte[] decode(GridNioSession ses, ByteBuffer buf) throws IOException, IgniteCheckedException {
        GridNioDelimitedBuffer nioBuf = (GridNioDelimitedBuffer)ses.meta(BUF_META_KEY);
        if (nioBuf == null) {
            nioBuf = new GridNioDelimitedBuffer(this.delim);
            GridNioDelimitedBuffer old = ses.addMeta(BUF_META_KEY, nioBuf);
            assert (old == null);
        }
        return nioBuf.read(buf);
    }

    @Override
    public ByteBuffer encode(GridNioSession ses, Object msg) throws IOException, IgniteCheckedException {
        byte[] msg0 = (byte[])msg;
        int cap = msg0.length + this.delim.length;
        ByteBuffer res = this.directBuf ? ByteBuffer.allocateDirect(cap) : ByteBuffer.allocate(cap);
        res.put(msg0);
        res.put(this.delim);
        res.flip();
        return res;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

