/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.serializer.direct.util;

import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Date;
import java.util.UUID;
import org.apache.hugegraph.serializer.direct.struct.HugeType;
import org.apache.hugegraph.serializer.direct.util.Id;
import org.apache.hugegraph.serializer.direct.util.StringEncoding;
import org.apache.hugegraph.structure.constant.DataType;
import org.apache.hugegraph.util.Bytes;
import org.apache.hugegraph.util.E;

public final class BytesBuffer
extends OutputStream {
    public static final int BYTE_LEN = 1;
    public static final int SHORT_LEN = 2;
    public static final int INT_LEN = 4;
    public static final int LONG_LEN = 8;
    public static final int CHAR_LEN = 2;
    public static final int FLOAT_LEN = 4;
    public static final int DOUBLE_LEN = 8;
    public static final int BLOB_LEN = 4;
    public static final int UINT8_MAX = 255;
    public static final int UINT16_MAX = 65535;
    public static final long UINT32_MAX = 0xFFFFFFFFL;
    public static final int ID_LEN_MASK = 127;
    public static final int ID_LEN_MAX = 128;
    public static final int BIG_ID_LEN_MAX = 32768;
    public static final byte STRING_ENDING_BYTE = 0;
    public static final byte STRING_ENDING_BYTE_FF = -1;
    public static final int STRING_LEN_MAX = 65535;
    public static final long BLOB_LEN_MAX = 0x40000000L;
    public static final int INDEX_HASH_ID_THRESHOLD = 32;
    public static final int DEFAULT_CAPACITY = 64;
    public static final int MAX_BUFFER_CAPACITY = 0x8000000;
    public static final int BUF_EDGE_ID = 128;
    public static final int BUF_PROPERTY = 64;
    private ByteBuffer buffer;
    private final boolean resize;

    public BytesBuffer() {
        this(64);
    }

    public BytesBuffer(int capacity) {
        E.checkArgument(capacity <= 0x8000000, "Capacity exceeds max buffer capacity: %s", 0x8000000);
        this.buffer = ByteBuffer.allocate(capacity);
        this.resize = true;
    }

    public BytesBuffer(ByteBuffer buffer) {
        E.checkNotNull(buffer, "buffer");
        this.buffer = buffer;
        this.resize = false;
    }

    public static BytesBuffer allocate(int capacity) {
        return new BytesBuffer(capacity);
    }

    public static BytesBuffer wrap(ByteBuffer buffer) {
        return new BytesBuffer(buffer);
    }

    public static BytesBuffer wrap(byte[] array) {
        return new BytesBuffer(ByteBuffer.wrap(array));
    }

    public static BytesBuffer wrap(byte[] array, int offset, int length) {
        return new BytesBuffer(ByteBuffer.wrap(array, offset, length));
    }

    public ByteBuffer asByteBuffer() {
        return this.buffer;
    }

    public BytesBuffer forReadWritten() {
        this.buffer.flip();
        return this;
    }

    public BytesBuffer forReadAll() {
        this.buffer.position(this.buffer.limit());
        return this;
    }

    public byte[] array() {
        return this.buffer.array();
    }

    public byte[] bytes() {
        byte[] bytes = this.buffer.array();
        int position = this.buffer.position();
        if (position == bytes.length) {
            return bytes;
        }
        return Arrays.copyOf(bytes, position);
    }

    public int position() {
        return this.buffer.position();
    }

    public BytesBuffer copyFrom(BytesBuffer other) {
        this.write(other.bytes());
        return this;
    }

    public int remaining() {
        return this.buffer.remaining();
    }

    private void require(int size) {
        if (this.buffer.limit() - this.buffer.position() >= size) {
            return;
        }
        E.checkState(this.resize, "Can't resize for wrapped buffer", new Object[0]);
        int newcapacity = size + this.buffer.limit() + 64;
        E.checkArgument(newcapacity <= 0x8000000, "Capacity exceeds max buffer capacity: %s", 0x8000000);
        ByteBuffer newBuffer = ByteBuffer.allocate(newcapacity);
        this.buffer.flip();
        newBuffer.put(this.buffer);
        this.buffer = newBuffer;
    }

    public BytesBuffer write(byte val) {
        this.require(1);
        this.buffer.put(val);
        return this;
    }

    @Override
    public void write(int val) {
        assert (val <= 255);
        this.require(1);
        this.buffer.put((byte)val);
    }

    @Override
    public void write(byte[] val) {
        this.require(1 * val.length);
        this.buffer.put(val);
    }

    @Override
    public void write(byte[] val, int offset, int length) {
        this.require(1 * length);
        this.buffer.put(val, offset, length);
    }

    public BytesBuffer writeBoolean(boolean val) {
        this.write(val ? 1 : 0);
        return this;
    }

    public BytesBuffer writeChar(char val) {
        this.require(2);
        this.buffer.putChar(val);
        return this;
    }

    public BytesBuffer writeShort(short val) {
        this.require(2);
        this.buffer.putShort(val);
        return this;
    }

    public BytesBuffer writeInt(int val) {
        this.require(4);
        this.buffer.putInt(val);
        return this;
    }

    public BytesBuffer writeLong(long val) {
        this.require(8);
        this.buffer.putLong(val);
        return this;
    }

    public BytesBuffer writeFloat(float val) {
        this.require(4);
        this.buffer.putFloat(val);
        return this;
    }

    public BytesBuffer writeDouble(double val) {
        this.require(8);
        this.buffer.putDouble(val);
        return this;
    }

    public byte peek() {
        return this.buffer.get(this.buffer.position());
    }

    public byte peekLast() {
        return this.buffer.get(this.buffer.capacity() - 1);
    }

    public byte read() {
        return this.buffer.get();
    }

    public byte[] read(int length) {
        byte[] bytes = new byte[length];
        this.buffer.get(bytes);
        return bytes;
    }

    public boolean readBoolean() {
        return this.buffer.get() != 0;
    }

    public char readChar() {
        return this.buffer.getChar();
    }

    public short readShort() {
        return this.buffer.getShort();
    }

    public int readInt() {
        return this.buffer.getInt();
    }

    public long readLong() {
        return this.buffer.getLong();
    }

    public float readFloat() {
        return this.buffer.getFloat();
    }

    public double readDouble() {
        return this.buffer.getDouble();
    }

    public BytesBuffer writeBytes(byte[] bytes) {
        E.checkArgument(bytes.length <= 65535, "The max length of bytes is %s, but got %s", 65535, bytes.length);
        this.require(2 + bytes.length);
        this.writeVInt(bytes.length);
        this.write(bytes);
        return this;
    }

    public byte[] readBytes() {
        int length = this.readVInt();
        assert (length >= 0);
        byte[] bytes = this.read(length);
        return bytes;
    }

    public BytesBuffer writeBigBytes(byte[] bytes) {
        E.checkArgument((long)bytes.length <= 0x40000000L, "The max length of bytes is %s, but got %s", 0x40000000L, bytes.length);
        this.require(4 + bytes.length);
        this.writeVInt(bytes.length);
        this.write(bytes);
        return this;
    }

    public byte[] readBigBytes() {
        int length = this.readVInt();
        assert (length >= 0);
        byte[] bytes = this.read(length);
        return bytes;
    }

    public BytesBuffer writeStringRaw(String val) {
        this.write(StringEncoding.encode(val));
        return this;
    }

    public BytesBuffer writeString(String val) {
        byte[] bytes = StringEncoding.encode(val);
        this.writeBytes(bytes);
        return this;
    }

    public String readString() {
        return StringEncoding.decode(this.readBytes());
    }

    public BytesBuffer writeStringWithEnding(String value) {
        if (!value.isEmpty()) {
            byte[] bytes = StringEncoding.encode(value);
            assert (!Bytes.contains(bytes, (byte)-1)) : "Invalid UTF8 bytes: " + value;
            if (Bytes.contains(bytes, (byte)0)) {
                E.checkArgument(false, "Can't contains byte '0x00' in string: '%s'", value);
            }
            this.write(bytes);
        }
        this.write((byte)0);
        return this;
    }

    public String readStringWithEnding() {
        return StringEncoding.decode(this.readBytesWithEnding());
    }

    public BytesBuffer writeStringToRemaining(String value) {
        byte[] bytes = StringEncoding.encode(value);
        this.write(bytes);
        return this;
    }

    public String readStringFromRemaining() {
        byte[] bytes = new byte[this.buffer.remaining()];
        this.buffer.get(bytes);
        return StringEncoding.decode(bytes);
    }

    public BytesBuffer writeUInt8(int val) {
        assert (val <= 255);
        this.write(val);
        return this;
    }

    public int readUInt8() {
        return this.read() & 0xFF;
    }

    public BytesBuffer writeUInt16(int val) {
        assert (val <= 65535);
        this.writeShort((short)val);
        return this;
    }

    public int readUInt16() {
        return this.readShort() & 0xFFFF;
    }

    public BytesBuffer writeUInt32(long val) {
        assert (val <= 0xFFFFFFFFL);
        this.writeInt((int)val);
        return this;
    }

    public long readUInt32() {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    public BytesBuffer writeVInt(int value) {
        if (value > 0xFFFFFFF || value < 0) {
            this.write(0x80 | value >>> 28 & 0x7F);
        }
        if (value > 0x1FFFFF || value < 0) {
            this.write(0x80 | value >>> 21 & 0x7F);
        }
        if (value > 16383 || value < 0) {
            this.write(0x80 | value >>> 14 & 0x7F);
        }
        if (value > 127 || value < 0) {
            this.write(0x80 | value >>> 7 & 0x7F);
        }
        this.write(value & 0x7F);
        return this;
    }

    public int readVInt() {
        int i;
        byte leading = this.read();
        E.checkArgument(leading != 128, "Unexpected varint with leading byte '0x%s'", Bytes.toHex(leading));
        int value = leading & 0x7F;
        if (leading >= 0) {
            assert ((leading & 0x80) == 0);
            return value;
        }
        for (i = 1; i < 5; ++i) {
            byte b = this.read();
            if (b >= 0) {
                value = b | value << 7;
                break;
            }
            value = b & 0x7F | value << 7;
        }
        E.checkArgument(i < 5, "Unexpected varint %s with too many bytes(%s)", value, i + 1);
        E.checkArgument(i < 4 || (leading & 0x70) == 0, "Unexpected varint %s with leading byte '0x%s'", value, Bytes.toHex(leading));
        return value;
    }

    public BytesBuffer writeVLong(long value) {
        if (value < 0L) {
            this.write((byte)-127);
        }
        if (value > 0xFFFFFFFFFFFFFFL || value < 0L) {
            this.write(0x80 | (int)(value >>> 56) & 0x7F);
        }
        if (value > 0x1FFFFFFFFFFFFL || value < 0L) {
            this.write(0x80 | (int)(value >>> 49) & 0x7F);
        }
        if (value > 0x3FFFFFFFFFFL || value < 0L) {
            this.write(0x80 | (int)(value >>> 42) & 0x7F);
        }
        if (value > 0x7FFFFFFFFL || value < 0L) {
            this.write(0x80 | (int)(value >>> 35) & 0x7F);
        }
        if (value > 0xFFFFFFFL || value < 0L) {
            this.write(0x80 | (int)(value >>> 28) & 0x7F);
        }
        if (value > 0x1FFFFFL || value < 0L) {
            this.write(0x80 | (int)(value >>> 21) & 0x7F);
        }
        if (value > 16383L || value < 0L) {
            this.write(0x80 | (int)(value >>> 14) & 0x7F);
        }
        if (value > 127L || value < 0L) {
            this.write(0x80 | (int)(value >>> 7) & 0x7F);
        }
        this.write((int)value & 0x7F);
        return this;
    }

    public long readVLong() {
        int i;
        byte leading = this.read();
        E.checkArgument(leading != 128, "Unexpected varlong with leading byte '0x%s'", Bytes.toHex(leading));
        long value = (long)leading & 0x7FL;
        if (leading >= 0) {
            assert ((leading & 0x80) == 0);
            return value;
        }
        for (i = 1; i < 10; ++i) {
            byte b = this.read();
            if (b >= 0) {
                value = (long)b | value << 7;
                break;
            }
            value = (long)(b & 0x7F) | value << 7;
        }
        E.checkArgument(i < 10, "Unexpected varlong %s with too many bytes(%s)", value, i + 1);
        E.checkArgument(i < 9 || (leading & 0x7E) == 0, "Unexpected varlong %s with leading byte '0x%s'", value, Bytes.toHex(leading));
        return value;
    }

    public BytesBuffer writeId(Id id) {
        return this.writeId(id, false);
    }

    public BytesBuffer writeId(Id id, boolean big) {
        switch (id.type()) {
            case LONG: {
                long value = id.asLong();
                this.writeNumber(value);
                break;
            }
            case UUID: {
                byte[] bytes = id.asBytes();
                assert (bytes.length == 16);
                this.writeUInt8(127);
                this.write(bytes);
                break;
            }
            default: {
                byte[] bytes = id.asBytes();
                int len = bytes.length;
                E.checkArgument(len > 0, "Can't write empty id", new Object[0]);
                if (!big) {
                    E.checkArgument(len <= 128, "Id max length is %s, but got %s {%s}", 128, len, id);
                    this.writeUInt8(--len | 0x80);
                } else {
                    E.checkArgument(len <= 32768, "Big id max length is %s, but got %s {%s}", 32768, len, id);
                    int high = --len >> 8;
                    int low = len & 0xFF;
                    this.writeUInt8(high | 0x80);
                    this.writeUInt8(low);
                }
                this.write(bytes);
            }
        }
        return this;
    }

    public BytesBuffer writeIndexId(Id id, HugeType type) {
        return this.writeIndexId(id, type, true);
    }

    public BytesBuffer writeIndexId(Id id, HugeType type, boolean withEnding) {
        byte[] bytes = id.asBytes();
        int len = bytes.length;
        E.checkArgument(len > 0, "Can't write empty id", new Object[0]);
        this.write(bytes);
        if (type.isStringIndex()) {
            if (Bytes.contains(bytes, (byte)0)) {
                E.checkArgument(false, "The %s type index id can't contains byte '0x%s', but got: 0x%s", new Object[]{type, Bytes.toHex((byte)0), Bytes.toHex(bytes)});
            }
            if (withEnding) {
                this.writeStringWithEnding("");
            }
        }
        return this;
    }

    private void writeNumber(long val) {
        int positive;
        int n = positive = val >= 0L ? 8 : 0;
        if (-2048L <= val && val <= 2047L) {
            int high3bits = (int)(val >> 8) & 7;
            this.writeUInt8(0 | positive | high3bits);
            this.writeUInt8((byte)val);
        } else if (-524288L <= val && val <= 524287L) {
            int high3bits = (int)(val >> 16) & 7;
            this.writeUInt8(0x10 | positive | high3bits);
            this.writeShort((short)val);
        } else if (-134217728L <= val && val <= 0x7FFFFFFL) {
            int high3bits = (int)(val >> 24 & 7L);
            this.writeUInt8(0x20 | positive | high3bits);
            this.write((byte)(val >> 16));
            this.writeShort((short)val);
        } else if (-34359738368L <= val && val <= 0x7FFFFFFFFL) {
            int high3bits = (int)(val >> 32) & 7;
            this.writeUInt8(0x30 | positive | high3bits);
            this.writeInt((int)val);
        } else if (-8796093022208L <= val && val <= 0x7FFFFFFFFFFL) {
            int high3bits = (int)(val >> 40) & 7;
            this.writeUInt8(0x40 | positive | high3bits);
            this.write((byte)(val >> 32));
            this.writeInt((int)val);
        } else if (-2251799813685248L <= val && val <= 0x7FFFFFFFFFFFFL) {
            int high3bits = (int)(val >> 48) & 7;
            this.writeUInt8(0x50 | positive | high3bits);
            this.writeShort((short)(val >> 32));
            this.writeInt((int)val);
        } else if (-576460752303423488L <= val && val <= 0x7FFFFFFFFFFFFFFL) {
            int high3bits = (int)(val >> 56) & 7;
            this.writeUInt8(0x60 | positive | high3bits);
            this.write((byte)(val >> 48));
            this.writeShort((short)(val >> 32));
            this.writeInt((int)val);
        } else {
            this.writeUInt8(0x70 | positive);
            this.writeLong(val);
        }
    }

    private long readNumber(byte b) {
        E.checkArgument((b & 0x80) == 0, "Not a number type with prefix byte '0x%s'", Bytes.toHex(b));
        int kind = b >>> 4;
        boolean positive = (b & 8) > 0;
        long high3bits = b & 7;
        long value = high3bits << (kind + 1) * 8;
        switch (kind) {
            case 0: {
                value |= (long)this.readUInt8();
                break;
            }
            case 1: {
                value |= (long)this.readUInt16();
                break;
            }
            case 2: {
                value |= (long)(this.readUInt8() << 16 | this.readUInt16());
                break;
            }
            case 3: {
                value |= this.readUInt32();
                break;
            }
            case 4: {
                value |= (long)this.readUInt8() << 32 | this.readUInt32();
                break;
            }
            case 5: {
                value |= (long)this.readUInt16() << 32 | this.readUInt32();
                break;
            }
            case 6: {
                value |= (long)this.readUInt8() << 48 | (long)this.readUInt16() << 32 | this.readUInt32();
                break;
            }
            case 7: {
                assert (high3bits == 0L);
                value |= this.readLong();
                break;
            }
            default: {
                throw new AssertionError((Object)("Invalid length of number: " + kind));
            }
        }
        if (!positive && kind < 7) {
            long mask = Long.MIN_VALUE >> 52 - kind * 8;
            value |= mask;
        }
        return value;
    }

    private byte[] readBytesWithEnding() {
        int start = this.buffer.position();
        boolean foundEnding = false;
        while (this.remaining() > 0) {
            byte current = this.read();
            if (current != 0) continue;
            foundEnding = true;
            break;
        }
        E.checkArgument(foundEnding, "Not found ending '0x%s'", Bytes.toHex((byte)0));
        int end = this.buffer.position() - 1;
        int len = end - start;
        byte[] bytes = new byte[len];
        System.arraycopy(this.array(), start, bytes, 0, len);
        return bytes;
    }

    public void writeProperty(DataType dataType, Object value) {
        switch (dataType) {
            case BOOLEAN: {
                this.writeVInt((Boolean)value != false ? 1 : 0);
                break;
            }
            case BYTE: {
                this.writeVInt(((Byte)value).byteValue());
                break;
            }
            case INT: {
                this.writeVInt((Integer)value);
                break;
            }
            case FLOAT: {
                this.writeFloat(((Float)value).floatValue());
                break;
            }
            case LONG: {
                this.writeVLong((Long)value);
                break;
            }
            case DATE: {
                this.writeVLong(((Date)value).getTime());
                break;
            }
            case DOUBLE: {
                this.writeDouble((Double)value);
                break;
            }
            case TEXT: {
                this.writeString((String)value);
                break;
            }
            case UUID: {
                UUID uuid = (UUID)value;
                this.writeLong(uuid.getMostSignificantBits());
                this.writeLong(uuid.getLeastSignificantBits());
                break;
            }
        }
    }
}

