/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.variables;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.rest.RestResult;
import org.apache.hugegraph.structure.constant.HugeType;

public class VariablesAPI
extends API {
    private static final String PATH = "graphs/%s/%s";

    public VariablesAPI(RestClient client, String graph) {
        super(client);
        this.path(PATH, graph, this.type());
    }

    @Override
    protected String type() {
        return HugeType.VARIABLES.string();
    }

    public Map<String, Object> get(String key) {
        RestResult result = this.client.get(this.path(), key);
        return result.readObject(Map.class);
    }

    public Map<String, Object> set(String key, Object value) {
        value = ImmutableMap.of("data", value);
        RestResult result = this.client.put(this.path(), key, value);
        return result.readObject(Map.class);
    }

    public void remove(String key) {
        this.client.delete(this.path(), key);
    }

    public Map<String, Object> all() {
        RestResult result = this.client.get(this.path());
        return result.readObject(Map.class);
    }
}

