/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.store.file.bufferfile;

import java.io.File;
import java.io.IOException;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.io.IOFactory;
import org.apache.hugegraph.computer.core.io.RandomAccessInput;
import org.apache.hugegraph.computer.core.store.EntryIterator;
import org.apache.hugegraph.computer.core.store.KvEntryFileReader;
import org.apache.hugegraph.computer.core.store.entry.EntriesUtil;
import org.apache.hugegraph.computer.core.store.entry.KvEntry;

public class BufferFileEntryReader
implements KvEntryFileReader {
    private final File file;
    private final boolean withSubKv;

    public BufferFileEntryReader(String path, boolean withSubKv) {
        this.file = new File(path);
        this.withSubKv = withSubKv;
    }

    public BufferFileEntryReader(String path) {
        this(path, false);
    }

    @Override
    public EntryIterator iterator() {
        return new EntryIter();
    }

    private class EntryIter
    implements EntryIterator {
        public final RandomAccessInput input;
        private final RandomAccessInput userAccessInput;

        public EntryIter() {
            try {
                this.input = IOFactory.createFileInput(BufferFileEntryReader.this.file);
                this.userAccessInput = this.input.duplicate();
            }
            catch (IOException e) {
                throw new ComputerException(e.getMessage(), (Throwable)e);
            }
        }

        public void close() throws Exception {
            this.input.close();
            this.userAccessInput.close();
        }

        public boolean hasNext() {
            try {
                return this.input.available() > 0L;
            }
            catch (IOException e) {
                throw new ComputerException(e.getMessage(), (Throwable)e);
            }
        }

        public KvEntry next() {
            return EntriesUtil.kvEntryFromInput(this.input, this.userAccessInput, true, BufferFileEntryReader.this.withSubKv);
        }
    }
}

