/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.regionserver.wal.AbstractProtobufLogWriter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.wal.FSHLogProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ProtobufLogWriter
extends AbstractProtobufLogWriter
implements FSHLogProvider.Writer {
    private static final Logger LOG = LoggerFactory.getLogger(ProtobufLogWriter.class);
    protected FSDataOutputStream output;

    @Override
    public void append(WAL.Entry entry) throws IOException {
        entry.getKey().getBuilder(this.compressor).setFollowingKvCount(entry.getEdit().size()).build().writeDelimitedTo((OutputStream)this.output);
        for (Cell cell : entry.getEdit().getCells()) {
            this.cellEncoder.write(cell);
        }
        this.length.set(this.output.getPos());
    }

    @Override
    public void close() throws IOException {
        if (this.output != null) {
            try {
                if (!this.trailerWritten) {
                    this.writeWALTrailer();
                }
                this.output.close();
            }
            catch (NullPointerException npe) {
                LOG.warn(npe.toString(), (Throwable)npe);
            }
            this.output = null;
        }
    }

    @Override
    public void sync(boolean forceSync) throws IOException {
        FSDataOutputStream fsdos = this.output;
        if (fsdos == null) {
            return;
        }
        fsdos.flush();
        if (forceSync) {
            fsdos.hsync();
        } else {
            fsdos.hflush();
        }
    }

    public FSDataOutputStream getStream() {
        return this.output;
    }

    @Override
    protected void initOutput(FileSystem fs, Path path, boolean overwritable, int bufferSize, short replication, long blockSize) throws IOException, CommonFSUtils.StreamLacksCapabilityException {
        this.output = CommonFSUtils.createForWal((FileSystem)fs, (Path)path, (boolean)overwritable, (int)bufferSize, (short)replication, (long)blockSize, (boolean)false);
        if (fs.getConf().getBoolean("hbase.unsafe.stream.capability.enforce", true)) {
            if (!CommonFSUtils.hasCapability((FSDataOutputStream)this.output, (String)"hflush")) {
                throw new CommonFSUtils.StreamLacksCapabilityException("hflush");
            }
            if (!CommonFSUtils.hasCapability((FSDataOutputStream)this.output, (String)"hsync")) {
                throw new CommonFSUtils.StreamLacksCapabilityException("hsync");
            }
        }
    }

    @Override
    protected long writeMagicAndWALHeader(byte[] magic, WALProtos.WALHeader header) throws IOException {
        this.output.write(magic);
        header.writeDelimitedTo((OutputStream)this.output);
        return this.output.getPos();
    }

    @Override
    protected OutputStream getOutputStreamForCellEncoder() {
        return this.output;
    }

    @Override
    protected long writeWALTrailerAndMagic(WALProtos.WALTrailer trailer, byte[] magic) throws IOException {
        trailer.writeTo((OutputStream)this.output);
        this.output.writeInt(trailer.getSerializedSize());
        this.output.write(magic);
        return this.output.getPos();
    }
}

