/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.algorithm.path.rings;

import java.util.Iterator;
import org.apache.hugegraph.computer.core.graph.edge.Edge;
import org.apache.hugegraph.computer.core.graph.id.Id;
import org.apache.hugegraph.computer.core.graph.value.IdList;
import org.apache.hugegraph.computer.core.graph.value.IdListList;
import org.apache.hugegraph.computer.core.graph.value.Value;
import org.apache.hugegraph.computer.core.graph.vertex.Vertex;
import org.apache.hugegraph.computer.core.worker.Computation;
import org.apache.hugegraph.computer.core.worker.ComputationContext;

public class RingsDetection
implements Computation<IdList> {
    public String name() {
        return "rings";
    }

    public String category() {
        return "path";
    }

    public void compute0(ComputationContext context, Vertex vertex) {
        vertex.value((Value)new IdListList());
        if (vertex.edges().size() == 0) {
            return;
        }
        Id id = vertex.id();
        IdList path = new IdList();
        path.add((Value.Tvalue)id);
        for (Edge edge : vertex.edges()) {
            if (id.compareTo((Object)edge.targetId()) > 0) continue;
            context.sendMessage(edge.targetId(), (Value)path);
        }
    }

    public void compute(ComputationContext context, Vertex vertex, Iterator<IdList> messages) {
        Id id = vertex.id();
        boolean halt = true;
        while (messages.hasNext()) {
            Id pathVertexValue;
            int i;
            halt = false;
            IdList sequence = messages.next();
            if (id.equals(sequence.get(0))) {
                boolean isMin = true;
                for (i = 1; i < sequence.size(); ++i) {
                    pathVertexValue = (Id)sequence.get(i);
                    if (id.compareTo((Object)pathVertexValue) <= 0) continue;
                    isMin = false;
                    break;
                }
                if (!isMin) continue;
                sequence.add((Value.Tvalue)id);
                IdListList sequences = (IdListList)vertex.value();
                sequences.add((Value.Tvalue)sequence);
                continue;
            }
            boolean contains = false;
            for (i = 0; i < sequence.size(); ++i) {
                pathVertexValue = (Id)sequence.get(i);
                if (!pathVertexValue.equals(vertex.id())) continue;
                contains = true;
                break;
            }
            Id ringId = (Id)sequence.get(0);
            if (contains) continue;
            sequence.add((Value.Tvalue)vertex.id());
            for (Edge edge : vertex.edges()) {
                if (ringId.compareTo((Object)edge.targetId()) > 0) continue;
                context.sendMessage(edge.targetId(), (Value)sequence);
            }
        }
        if (halt) {
            vertex.inactivate();
        }
    }
}

