/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.HashMap;
import java.util.Map;
import org.apache.helix.controller.LogUtil;
import org.apache.helix.controller.dataproviders.BaseControllerDataProvider;
import org.apache.helix.controller.dataproviders.ResourceControllerDataProvider;
import org.apache.helix.controller.dataproviders.WorkflowControllerDataProvider;
import org.apache.helix.controller.pipeline.AbstractAsyncBaseStage;
import org.apache.helix.controller.pipeline.AsyncWorkerType;
import org.apache.helix.controller.pipeline.StageException;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.controller.stages.MissingTopStateRecord;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Message;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.monitoring.mbeans.ClusterStatusMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopStateHandoffReportStage
extends AbstractAsyncBaseStage {
    private static final long DEFAULT_HANDOFF_USER_LATENCY = 0L;
    private static Logger LOG = LoggerFactory.getLogger(TopStateHandoffReportStage.class);
    public static final long TIMESTAMP_NOT_RECORDED = -1L;
    private Map<String, Long> _failingPartitionsInfoMap = new HashMap<String, Long>();

    @Override
    public AsyncWorkerType getAsyncWorkerType() {
        return AsyncWorkerType.TopStateHandoffReportWorker;
    }

    @Override
    public void execute(ClusterEvent event) throws Exception {
        this._eventId = event.getEventId();
        BaseControllerDataProvider cache = (BaseControllerDataProvider)event.getAttribute(AttributeName.ControllerDataProvider.name());
        Long lastPipelineFinishTimestamp = event.getAttributeWithDefault(AttributeName.LastRebalanceFinishTimeStamp.name(), -1L);
        Map resourceMap = (Map)event.getAttribute(AttributeName.RESOURCES.name());
        CurrentStateOutput currentStateOutput = (CurrentStateOutput)event.getAttribute(AttributeName.CURRENT_STATE.name());
        ClusterStatusMonitor clusterStatusMonitor = (ClusterStatusMonitor)event.getAttribute(AttributeName.clusterStatusMonitor.name());
        if (cache == null || resourceMap == null || currentStateOutput == null) {
            throw new StageException("Missing critical attributes for stage, requires ResourceControllerDataProvider, RESOURCES and CURRENT_STATE");
        }
        if (cache instanceof WorkflowControllerDataProvider) {
            throw new StageException("TopStateHandoffReportStage can only be used in resource pipeline");
        }
        this.updateTopStateStatus((ResourceControllerDataProvider)cache, clusterStatusMonitor, resourceMap, currentStateOutput, lastPipelineFinishTimestamp);
    }

    private void updateTopStateStatus(ResourceControllerDataProvider cache, ClusterStatusMonitor clusterStatusMonitor, Map<String, Resource> resourceMap, CurrentStateOutput currentStateOutput, long lastPipelineFinishTimestamp) {
        Map<String, Map<String, MissingTopStateRecord>> missingTopStateMap = cache.getMissingTopStateMap();
        Map<String, Map<String, String>> lastTopStateMap = cache.getLastTopStateLocationMap();
        long durationThreshold = Long.MAX_VALUE;
        if (cache.getClusterConfig() != null) {
            durationThreshold = cache.getClusterConfig().getMissTopStateDurationThreshold();
        }
        missingTopStateMap.keySet().retainAll(resourceMap.keySet());
        lastTopStateMap.keySet().retainAll(resourceMap.keySet());
        for (Resource resource : resourceMap.values()) {
            StateModelDefinition stateModelDef = cache.getStateModelDef(resource.getStateModelDefRef());
            if (stateModelDef == null || resource.getStateModelDefRef().equalsIgnoreCase("Task")) continue;
            String resourceName = resource.getResourceName();
            this._failingPartitionsInfoMap.clear();
            for (Partition partition : resource.getPartitions()) {
                String currentTopStateInstance = this.findCurrentTopStateLocation(currentStateOutput, resourceName, partition, stateModelDef);
                String lastTopStateInstance = this.findCachedTopStateLocation(cache, resourceName, partition);
                if (currentTopStateInstance != null) {
                    this.reportTopStateExistence(cache, currentStateOutput, stateModelDef, resourceName, partition, lastTopStateInstance, currentTopStateInstance, clusterStatusMonitor, durationThreshold, lastPipelineFinishTimestamp);
                    this.updateCachedTopStateLocation(cache, resourceName, partition, currentTopStateInstance);
                    continue;
                }
                this.reportTopStateMissing(cache, resourceName, partition, stateModelDef.getTopState(), currentStateOutput);
                this.reportTopStateHandoffFailIfNecessary(cache, resourceName, partition, durationThreshold, clusterStatusMonitor);
            }
            if (this._failingPartitionsInfoMap.isEmpty()) continue;
            LogUtil.logInfo(LOG, this._eventId, String.format("Missing top state for partitions: %s", this._failingPartitionsInfoMap));
        }
        if (clusterStatusMonitor != null) {
            clusterStatusMonitor.resetMaxMissingTopStateGauge();
        }
    }

    private String findCurrentTopStateLocation(CurrentStateOutput currentStateOutput, String resourceName, Partition partition, StateModelDefinition stateModelDef) {
        Map<String, String> stateMap = currentStateOutput.getCurrentStateMap(resourceName, partition);
        for (String instance : stateMap.keySet()) {
            if (!stateMap.get(instance).equals(stateModelDef.getTopState())) continue;
            return instance;
        }
        return null;
    }

    private String findCachedTopStateLocation(ResourceControllerDataProvider cache, String resourceName, Partition partition) {
        Map<String, Map<String, String>> lastTopStateMap = cache.getLastTopStateLocationMap();
        return lastTopStateMap.containsKey(resourceName) && lastTopStateMap.get(resourceName).containsKey(partition.getPartitionName()) ? lastTopStateMap.get(resourceName).get(partition.getPartitionName()) : null;
    }

    private void updateCachedTopStateLocation(ResourceControllerDataProvider cache, String resourceName, Partition partition, String currentTopStateInstance) {
        Map<String, Map<String, String>> lastTopStateMap = cache.getLastTopStateLocationMap();
        if (!lastTopStateMap.containsKey(resourceName)) {
            lastTopStateMap.put(resourceName, new HashMap());
        }
        lastTopStateMap.get(resourceName).put(partition.getPartitionName(), currentTopStateInstance);
    }

    private void reportTopStateExistence(ResourceControllerDataProvider cache, CurrentStateOutput currentStateOutput, StateModelDefinition stateModelDef, String resourceName, Partition partition, String lastTopStateInstance, String currentTopStateInstance, ClusterStatusMonitor clusterStatusMonitor, long durationThreshold, long lastPipelineFinishTimestamp) {
        Map<String, Map<String, MissingTopStateRecord>> missingTopStateMap = cache.getMissingTopStateMap();
        if (missingTopStateMap.containsKey(resourceName) && missingTopStateMap.get(resourceName).containsKey(partition.getPartitionName())) {
            this.reportTopStateComesBack(cache, currentStateOutput.getCurrentStateMap(resourceName, partition), resourceName, partition, clusterStatusMonitor, durationThreshold, stateModelDef.getTopState());
        } else if (lastTopStateInstance != null) {
            this.reportSingleTopStateHandoff(cache, lastTopStateInstance, currentTopStateInstance, resourceName, partition, clusterStatusMonitor, lastPipelineFinishTimestamp);
        } else {
            LogUtil.logDebug(LOG, this._eventId, String.format("No top state hand off or first-seen top state for %s. CurNode: %s, LastNode: %s.", partition.getPartitionName(), currentTopStateInstance, lastTopStateInstance));
        }
    }

    private void reportSingleTopStateHandoff(ResourceControllerDataProvider cache, String lastTopStateInstance, String curTopStateInstance, String resourceName, Partition partition, ClusterStatusMonitor clusterStatusMonitor, long lastPipelineFinishTimestamp) {
        String lastTopStateSession;
        String curTopStateSession = cache.getLiveInstances().get(curTopStateInstance).getEphemeralOwner();
        long endTime = cache.getCurrentState(curTopStateInstance, curTopStateSession).get(resourceName).getEndTime(partition.getPartitionName());
        long toTopStateuserLatency = endTime - cache.getCurrentState(curTopStateInstance, curTopStateSession).get(resourceName).getStartTime(partition.getPartitionName());
        long startTime = -1L;
        long fromTopStateUserLatency = 0L;
        if (!curTopStateInstance.equals(lastTopStateInstance) && cache.getLiveInstances().containsKey(lastTopStateInstance) && cache.getCurrentState(lastTopStateInstance, lastTopStateSession = cache.getLiveInstances().get(lastTopStateInstance).getEphemeralOwner()).get(resourceName) != null) {
            startTime = cache.getCurrentState(lastTopStateInstance, lastTopStateSession).get(resourceName).getStartTime(partition.getPartitionName());
            fromTopStateUserLatency = cache.getCurrentState(lastTopStateInstance, lastTopStateSession).get(resourceName).getEndTime(partition.getPartitionName()) - startTime;
        }
        if (startTime == -1L) {
            startTime = lastPipelineFinishTimestamp;
            fromTopStateUserLatency = 0L;
        }
        if (startTime == -1L || startTime > endTime) {
            LogUtil.logDebug(LOG, this._eventId, String.format("Cannot confirm top state missing start time. %s:%s->%s. Likely it was very fast", partition.getPartitionName(), lastTopStateInstance, curTopStateInstance));
            return;
        }
        long duration = endTime - startTime;
        long helixLatency = duration - fromTopStateUserLatency - toTopStateuserLatency;
        this.logMissingTopStateInfo(duration, helixLatency, true, partition.getPartitionName());
        if (clusterStatusMonitor != null) {
            clusterStatusMonitor.updateMissingTopStateDurationStats(resourceName, duration, helixLatency, true, true);
        }
    }

    private void reportTopStateHandoffFailIfNecessary(ResourceControllerDataProvider cache, String resourceName, Partition partition, long durationThreshold, ClusterStatusMonitor clusterStatusMonitor) {
        Map<String, Map<String, MissingTopStateRecord>> missingTopStateMap = cache.getMissingTopStateMap();
        String partitionName = partition.getPartitionName();
        MissingTopStateRecord record = missingTopStateMap.get(resourceName).get(partitionName);
        long startTime = record.getStartTimeStamp();
        long missingDuration = System.currentTimeMillis() - startTime;
        if (startTime > 0L && missingDuration > durationThreshold && !record.isFailed()) {
            record.setFailed();
            missingTopStateMap.get(resourceName).put(partitionName, record);
            LogUtil.logDebug(LOG, this._eventId, String.format("Missing top state for partition %s beyond %s time. Graceful: %s", partitionName, missingDuration, false));
            this._failingPartitionsInfoMap.put(partitionName, missingDuration);
            if (clusterStatusMonitor != null) {
                clusterStatusMonitor.updateMissingTopStateDurationStats(resourceName, 0L, 0L, false, false);
            }
        }
    }

    private void reportTopStateMissing(ResourceControllerDataProvider cache, String resourceName, Partition partition, String topState, CurrentStateOutput currentStateOutput) {
        Map<String, Map<String, MissingTopStateRecord>> missingTopStateMap = cache.getMissingTopStateMap();
        Map<String, Map<String, String>> lastTopStateMap = cache.getLastTopStateLocationMap();
        if (missingTopStateMap.containsKey(resourceName) && missingTopStateMap.get(resourceName).containsKey(partition.getPartitionName())) {
            return;
        }
        long startTime = -1L;
        long fromTopStateUserLatency = 0L;
        boolean isGraceful = true;
        String missingStateInstance = null;
        if (lastTopStateMap.containsKey(resourceName)) {
            missingStateInstance = lastTopStateMap.get(resourceName).get(partition.getPartitionName());
        }
        if (missingStateInstance != null) {
            Map<String, LiveInstance> liveInstances = cache.getLiveInstances();
            if (liveInstances.containsKey(missingStateInstance)) {
                CurrentState currentState = cache.getCurrentState(missingStateInstance, liveInstances.get(missingStateInstance).getEphemeralOwner()).get(resourceName);
                if (currentState != null && currentState.getPreviousState(partition.getPartitionName()) != null && currentState.getPreviousState(partition.getPartitionName()).equalsIgnoreCase(topState)) {
                    long fromTopStateStartTime = currentState.getStartTime(partition.getPartitionName());
                    if (fromTopStateStartTime > startTime) {
                        startTime = fromTopStateStartTime;
                        fromTopStateUserLatency = currentState.getEndTime(partition.getPartitionName()) - startTime;
                    }
                    startTime = Math.max(startTime, currentState.getStartTime(partition.getPartitionName()));
                }
            } else {
                isGraceful = false;
                Map<String, Long> offlineMap = cache.getInstanceOfflineTimeMap();
                if (offlineMap.containsKey(missingStateInstance)) {
                    startTime = Math.max(startTime, offlineMap.get(missingStateInstance));
                }
            }
        }
        if (startTime == -1L) {
            for (Message message : currentStateOutput.getPendingMessageMap(resourceName, partition).values()) {
                if (!message.getToState().equals(topState)) continue;
                startTime = Math.max(startTime, message.getCreateTimeStamp());
            }
        }
        if (startTime == -1L) {
            LogUtil.logWarn(LOG, this._eventId, "Cannot confirm top state missing start time. Use the current system time as the start time.");
            startTime = System.currentTimeMillis();
        }
        if (!missingTopStateMap.containsKey(resourceName)) {
            missingTopStateMap.put(resourceName, new HashMap());
        }
        missingTopStateMap.get(resourceName).put(partition.getPartitionName(), new MissingTopStateRecord(startTime, fromTopStateUserLatency, isGraceful));
    }

    private void reportTopStateComesBack(ResourceControllerDataProvider cache, Map<String, String> stateMap, String resourceName, Partition partition, ClusterStatusMonitor clusterStatusMonitor, long threshold, String topState) {
        Map<String, Map<String, MissingTopStateRecord>> missingTopStateMap = cache.getMissingTopStateMap();
        MissingTopStateRecord record = missingTopStateMap.get(resourceName).get(partition.getPartitionName());
        long handOffStartTime = record.getStartTimeStamp();
        long fromTopStateUserLatency = record.getUserLatency();
        long handOffEndTime = Long.MAX_VALUE;
        long toTopStateUserLatency = 0L;
        Map<String, LiveInstance> liveInstances = cache.getLiveInstances();
        for (String instanceName : stateMap.keySet()) {
            CurrentState currentState = cache.getCurrentState(instanceName, liveInstances.get(instanceName).getEphemeralOwner()).get(resourceName);
            if (!currentState.getState(partition.getPartitionName()).equalsIgnoreCase(topState) || currentState.getEndTime(partition.getPartitionName()) > handOffEndTime) continue;
            handOffEndTime = currentState.getEndTime(partition.getPartitionName());
            toTopStateUserLatency = handOffEndTime - currentState.getStartTime(partition.getPartitionName());
        }
        if (handOffStartTime > 0L && handOffEndTime - handOffStartTime <= threshold) {
            long duration = handOffEndTime - handOffStartTime;
            long helixLatency = duration - fromTopStateUserLatency - toTopStateUserLatency;
            duration = Math.max(duration, helixLatency);
            boolean isGraceful = record.isGracefulHandoff();
            this.logMissingTopStateInfo(duration, helixLatency, isGraceful, partition.getPartitionName());
            if (clusterStatusMonitor != null) {
                clusterStatusMonitor.updateMissingTopStateDurationStats(resourceName, duration, helixLatency, isGraceful, true);
            }
        }
        if (clusterStatusMonitor != null && record.isFailed()) {
            LogUtil.logInfo(LOG, this._eventId, String.format("Missing top state recovered for resource %s and partition %s. Decrementing missingTopStateBeyondThresholdGauge.", resourceName, partition.getPartitionName()));
            clusterStatusMonitor.decrementMissingTopStateBeyondThresholdGauge(resourceName);
        }
        this.removeFromStatsMap(missingTopStateMap, resourceName, partition);
    }

    private void removeFromStatsMap(Map<String, Map<String, MissingTopStateRecord>> missingTopStateMap, String resourceName, Partition partition) {
        if (missingTopStateMap.containsKey(resourceName)) {
            missingTopStateMap.get(resourceName).remove(partition.getPartitionName());
            if (missingTopStateMap.get(resourceName).isEmpty()) {
                missingTopStateMap.remove(resourceName);
            }
        }
    }

    private void logMissingTopStateInfo(long totalDuration, long helixLatency, boolean isGraceful, String partitionName) {
        LogUtil.logInfo(LOG, this._eventId, String.format("Missing top state duration is %s/%s (helix latency / end to end latency) for partition %s. Graceful: %s", helixLatency, totalDuration, partitionName, isGraceful));
    }
}

