/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.hadoop.hdfs.server.protocol;

import java.io.IOException;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

/**
 * This exception is thrown when a datanode sends a full block report but it is
 * rejected by the Namenode due to an invalid lease (expired or otherwise).
 *
 */
@InterfaceAudience.Private
@InterfaceStability.Evolving
public class InvalidBlockReportLeaseException extends IOException {
  /** for java.io.Serializable. */
  private static final long serialVersionUID = 1L;

  public InvalidBlockReportLeaseException(long blockReportID, long leaseID) {
    super("Block report 0x" + Long.toHexString(blockReportID) + " was rejected as lease 0x"
        + Long.toHexString(leaseID) +  " is invalid");
  }
}
