/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.client;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.client.BaseSchemaCatalog;
import org.apache.gravitino.client.DTOConverters;
import org.apache.gravitino.client.ErrorHandlers;
import org.apache.gravitino.client.GenericModel;
import org.apache.gravitino.client.GenericModelVersion;
import org.apache.gravitino.client.RESTClient;
import org.apache.gravitino.dto.AuditDTO;
import org.apache.gravitino.dto.CatalogDTO;
import org.apache.gravitino.dto.requests.ModelRegisterRequest;
import org.apache.gravitino.dto.requests.ModelUpdateRequest;
import org.apache.gravitino.dto.requests.ModelUpdatesRequest;
import org.apache.gravitino.dto.requests.ModelVersionLinkRequest;
import org.apache.gravitino.dto.requests.ModelVersionUpdateRequest;
import org.apache.gravitino.dto.requests.ModelVersionUpdatesRequest;
import org.apache.gravitino.dto.responses.BaseResponse;
import org.apache.gravitino.dto.responses.DropResponse;
import org.apache.gravitino.dto.responses.EntityListResponse;
import org.apache.gravitino.dto.responses.ModelResponse;
import org.apache.gravitino.dto.responses.ModelVersionInfoListResponse;
import org.apache.gravitino.dto.responses.ModelVersionListResponse;
import org.apache.gravitino.dto.responses.ModelVersionResponse;
import org.apache.gravitino.dto.responses.ModelVersionUriResponse;
import org.apache.gravitino.exceptions.ModelAlreadyExistsException;
import org.apache.gravitino.exceptions.ModelVersionAliasesAlreadyExistException;
import org.apache.gravitino.exceptions.NoSuchModelException;
import org.apache.gravitino.exceptions.NoSuchModelVersionException;
import org.apache.gravitino.exceptions.NoSuchModelVersionURINameException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.model.Model;
import org.apache.gravitino.model.ModelCatalog;
import org.apache.gravitino.model.ModelChange;
import org.apache.gravitino.model.ModelVersion;
import org.apache.gravitino.model.ModelVersionChange;
import org.apache.gravitino.rest.RESTRequest;
import org.apache.gravitino.rest.RESTUtils;
import org.apache.gravitino.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.gravitino.shaded.com.google.common.base.Preconditions;
import org.apache.gravitino.shaded.com.google.common.collect.ImmutableMap;
import org.apache.gravitino.shaded.org.apache.commons.lang3.StringUtils;

class GenericModelCatalog
extends BaseSchemaCatalog
implements ModelCatalog {
    GenericModelCatalog(Namespace namespace, String catalogName, Catalog.Type catalogType, String provider, String comment, Map<String, String> properties, AuditDTO auditDTO, RESTClient restClient) {
        super(namespace, catalogName, catalogType, provider, comment, properties, auditDTO, restClient);
    }

    @Override
    public ModelCatalog asModelCatalog() {
        return this;
    }

    @Override
    public NameIdentifier[] listModels(Namespace namespace) throws NoSuchSchemaException {
        this.checkModelNamespace(namespace);
        Namespace modelFullNs = this.modelFullNamespace(namespace);
        EntityListResponse resp = this.restClient.get(GenericModelCatalog.formatModelRequestPath(modelFullNs), EntityListResponse.class, Collections.emptyMap(), ErrorHandlers.modelErrorHandler());
        resp.validate();
        return (NameIdentifier[])Arrays.stream(resp.identifiers()).map(id -> NameIdentifier.of(id.namespace().level(2), id.name())).toArray(NameIdentifier[]::new);
    }

    @Override
    public Model getModel(NameIdentifier ident) throws NoSuchModelException {
        this.checkModelNameIdentifier(ident);
        Namespace modelFullNs = this.modelFullNamespace(ident.namespace());
        ModelResponse resp = this.restClient.get(GenericModelCatalog.formatModelRequestPath(modelFullNs) + "/" + RESTUtils.encodeString(ident.name()), ModelResponse.class, Collections.emptyMap(), ErrorHandlers.modelErrorHandler());
        resp.validate();
        return new GenericModel(resp.getModel(), this.restClient, modelFullNs);
    }

    @Override
    public Model registerModel(NameIdentifier ident, String comment, Map<String, String> properties) throws NoSuchSchemaException, ModelAlreadyExistsException {
        this.checkModelNameIdentifier(ident);
        Namespace modelFullNs = this.modelFullNamespace(ident.namespace());
        ModelRegisterRequest req = new ModelRegisterRequest(ident.name(), comment, properties);
        req.validate();
        ModelResponse resp = this.restClient.post(GenericModelCatalog.formatModelRequestPath(modelFullNs), (RESTRequest)req, ModelResponse.class, Collections.emptyMap(), ErrorHandlers.modelErrorHandler());
        resp.validate();
        return new GenericModel(resp.getModel(), this.restClient, modelFullNs);
    }

    @Override
    public boolean deleteModel(NameIdentifier ident) {
        this.checkModelNameIdentifier(ident);
        Namespace modelFullNs = this.modelFullNamespace(ident.namespace());
        DropResponse resp = this.restClient.delete(GenericModelCatalog.formatModelRequestPath(modelFullNs) + "/" + RESTUtils.encodeString(ident.name()), DropResponse.class, Collections.emptyMap(), ErrorHandlers.modelErrorHandler());
        resp.validate();
        return resp.dropped();
    }

    @Override
    public int[] listModelVersions(NameIdentifier ident) throws NoSuchModelException {
        this.checkModelNameIdentifier(ident);
        NameIdentifier modelFullIdent = this.modelFullNameIdentifier(ident);
        ModelVersionListResponse resp = this.restClient.get(GenericModelCatalog.formatModelVersionRequestPath(modelFullIdent) + "/versions", ModelVersionListResponse.class, Collections.emptyMap(), ErrorHandlers.modelErrorHandler());
        resp.validate();
        return resp.getVersions();
    }

    @Override
    public ModelVersion[] listModelVersionInfos(NameIdentifier ident) throws NoSuchModelException {
        this.checkModelNameIdentifier(ident);
        NameIdentifier modelFullIdent = this.modelFullNameIdentifier(ident);
        ModelVersionInfoListResponse resp = this.restClient.get(GenericModelCatalog.formatModelVersionRequestPath(modelFullIdent) + "/versions", ImmutableMap.of("details", "true"), ModelVersionInfoListResponse.class, Collections.emptyMap(), ErrorHandlers.modelErrorHandler());
        resp.validate();
        return resp.getVersions();
    }

    @Override
    public ModelVersion getModelVersion(NameIdentifier ident, int version) throws NoSuchModelVersionException {
        this.checkModelNameIdentifier(ident);
        Preconditions.checkArgument(version >= 0, "Model version must be non-negative");
        NameIdentifier modelFullIdent = this.modelFullNameIdentifier(ident);
        ModelVersionResponse resp = this.restClient.get(GenericModelCatalog.formatModelVersionRequestPath(modelFullIdent) + "/versions/" + version, ModelVersionResponse.class, Collections.emptyMap(), ErrorHandlers.modelErrorHandler());
        resp.validate();
        return new GenericModelVersion(resp.getModelVersion());
    }

    @Override
    public ModelVersion getModelVersion(NameIdentifier ident, String alias) throws NoSuchModelVersionException {
        this.checkModelNameIdentifier(ident);
        Preconditions.checkArgument(StringUtils.isNotBlank(alias), "Model alias must be non-empty");
        NameIdentifier modelFullIdent = this.modelFullNameIdentifier(ident);
        ModelVersionResponse resp = this.restClient.get(GenericModelCatalog.formatModelVersionRequestPath(modelFullIdent) + "/aliases/" + RESTUtils.encodeString(alias), ModelVersionResponse.class, Collections.emptyMap(), ErrorHandlers.modelErrorHandler());
        resp.validate();
        return new GenericModelVersion(resp.getModelVersion());
    }

    @Override
    public void linkModelVersion(NameIdentifier ident, Map<String, String> uris, String[] aliases, String comment, Map<String, String> properties) throws NoSuchModelException, ModelVersionAliasesAlreadyExistException {
        this.checkModelNameIdentifier(ident);
        ModelVersionLinkRequest req = new ModelVersionLinkRequest(uris, aliases, comment, properties);
        NameIdentifier modelFullIdent = this.modelFullNameIdentifier(ident);
        BaseResponse resp = this.restClient.post(GenericModelCatalog.formatModelVersionRequestPath(modelFullIdent) + "/versions", (RESTRequest)req, BaseResponse.class, Collections.emptyMap(), ErrorHandlers.modelErrorHandler());
        resp.validate();
    }

    @Override
    public String getModelVersionUri(NameIdentifier ident, int version, String uriName) throws NoSuchModelVersionException, NoSuchModelVersionURINameException {
        this.checkModelNameIdentifier(ident);
        Preconditions.checkArgument(version >= 0, "Model version must be non-negative");
        NameIdentifier modelFullIdent = this.modelFullNameIdentifier(ident);
        Map<String, String> queryParam = uriName == null ? Collections.emptyMap() : ImmutableMap.of("uriName", uriName);
        ModelVersionUriResponse resp = this.restClient.get(GenericModelCatalog.formatModelVersionRequestPath(modelFullIdent) + "/versions/" + version + "/uri", queryParam, ModelVersionUriResponse.class, Collections.emptyMap(), ErrorHandlers.modelErrorHandler());
        resp.validate();
        return resp.getUri();
    }

    @Override
    public String getModelVersionUri(NameIdentifier ident, String alias, String uriName) throws NoSuchModelVersionException, NoSuchModelVersionURINameException {
        this.checkModelNameIdentifier(ident);
        Preconditions.checkArgument(StringUtils.isNotBlank(alias), "Model alias must be non-empty");
        NameIdentifier modelFullIdent = this.modelFullNameIdentifier(ident);
        Map<String, String> queryParam = uriName == null ? Collections.emptyMap() : ImmutableMap.of("uriName", uriName);
        ModelVersionUriResponse resp = this.restClient.get(GenericModelCatalog.formatModelVersionRequestPath(modelFullIdent) + "/aliases/" + RESTUtils.encodeString(alias) + "/uri", queryParam, ModelVersionUriResponse.class, Collections.emptyMap(), ErrorHandlers.modelErrorHandler());
        resp.validate();
        return resp.getUri();
    }

    @Override
    public boolean deleteModelVersion(NameIdentifier ident, int version) {
        this.checkModelNameIdentifier(ident);
        Preconditions.checkArgument(version >= 0, "Model version must be non-negative");
        NameIdentifier modelFullIdent = this.modelFullNameIdentifier(ident);
        DropResponse resp = this.restClient.delete(GenericModelCatalog.formatModelVersionRequestPath(modelFullIdent) + "/versions/" + version, DropResponse.class, Collections.emptyMap(), ErrorHandlers.modelErrorHandler());
        resp.validate();
        return resp.dropped();
    }

    @Override
    public boolean deleteModelVersion(NameIdentifier ident, String alias) {
        this.checkModelNameIdentifier(ident);
        Preconditions.checkArgument(StringUtils.isNotBlank(alias), "Model alias must be non-empty");
        NameIdentifier modelFullIdent = this.modelFullNameIdentifier(ident);
        DropResponse resp = this.restClient.delete(GenericModelCatalog.formatModelVersionRequestPath(modelFullIdent) + "/aliases/" + RESTUtils.encodeString(alias), DropResponse.class, Collections.emptyMap(), ErrorHandlers.modelErrorHandler());
        resp.validate();
        return resp.dropped();
    }

    @Override
    public Model alterModel(NameIdentifier ident, ModelChange ... changes) throws NoSuchModelException, IllegalArgumentException {
        this.checkModelNameIdentifier(ident);
        List<ModelUpdateRequest> updateRequests = Arrays.stream(changes).map(DTOConverters::toModelUpdateRequest).collect(Collectors.toList());
        ModelUpdatesRequest req = new ModelUpdatesRequest(updateRequests);
        req.validate();
        Namespace modelFullNs = this.modelFullNamespace(ident.namespace());
        ModelResponse resp = this.restClient.put(GenericModelCatalog.formatModelRequestPath(modelFullNs) + "/" + RESTUtils.encodeString(ident.name()), (RESTRequest)req, ModelResponse.class, Collections.emptyMap(), ErrorHandlers.modelErrorHandler());
        resp.validate();
        return new GenericModel(resp.getModel(), this.restClient, modelFullNs);
    }

    @Override
    public ModelVersion alterModelVersion(NameIdentifier ident, int version, ModelVersionChange ... changes) throws NoSuchModelException, NoSuchModelVersionException, IllegalArgumentException {
        this.checkModelNameIdentifier(ident);
        List<ModelVersionUpdateRequest> updateRequests = Arrays.stream(changes).map(DTOConverters::toModelVersionUpdateRequest).collect(Collectors.toList());
        ModelVersionUpdatesRequest req = new ModelVersionUpdatesRequest(updateRequests);
        req.validate();
        NameIdentifier modelFullIdent = this.modelFullNameIdentifier(ident);
        ModelVersionResponse resp = this.restClient.put(GenericModelCatalog.formatModelVersionRequestPath(modelFullIdent) + "/versions/" + version, (RESTRequest)req, ModelVersionResponse.class, Collections.emptyMap(), ErrorHandlers.modelErrorHandler());
        resp.validate();
        return new GenericModelVersion(resp.getModelVersion());
    }

    @Override
    public ModelVersion alterModelVersion(NameIdentifier ident, String alias, ModelVersionChange ... changes) throws NoSuchModelException, IllegalArgumentException {
        this.checkModelNameIdentifier(ident);
        Preconditions.checkArgument(StringUtils.isNotBlank(alias), "Model alias must be non-empty");
        List<ModelVersionUpdateRequest> updateRequests = Arrays.stream(changes).map(DTOConverters::toModelVersionUpdateRequest).collect(Collectors.toList());
        ModelVersionUpdatesRequest req = new ModelVersionUpdatesRequest(updateRequests);
        req.validate();
        NameIdentifier modelFullIdent = this.modelFullNameIdentifier(ident);
        ModelVersionResponse resp = this.restClient.put(GenericModelCatalog.formatModelVersionRequestPath(modelFullIdent) + "/aliases/" + RESTUtils.encodeString(alias), (RESTRequest)req, ModelVersionResponse.class, Collections.emptyMap(), ErrorHandlers.modelErrorHandler());
        resp.validate();
        return new GenericModelVersion(resp.getModelVersion());
    }

    public static Builder builder() {
        return new Builder();
    }

    private void checkModelNamespace(Namespace namespace) {
        Namespace.check(namespace != null && namespace.length() == 1, "Model namespace must be non-null and only have 1 level, the input namespace is %s", namespace);
    }

    private void checkModelNameIdentifier(NameIdentifier ident) {
        NameIdentifier.check(ident != null, "Model name identifier must be non-null", new Object[0]);
        NameIdentifier.check(StringUtils.isNotBlank(ident.name()), "Model name identifier must have a non-empty name", new Object[0]);
        this.checkModelNamespace(ident.namespace());
    }

    private Namespace modelFullNamespace(Namespace modelNs) {
        return Namespace.of(this.catalogNamespace().level(0), this.name(), modelNs.level(0));
    }

    private NameIdentifier modelFullNameIdentifier(NameIdentifier modelIdent) {
        return NameIdentifier.of(this.modelFullNamespace(modelIdent.namespace()), modelIdent.name());
    }

    @VisibleForTesting
    static String formatModelRequestPath(Namespace modelNs) {
        Namespace schemaNs = Namespace.of(modelNs.level(0), modelNs.level(1));
        return GenericModelCatalog.formatSchemaRequestPath(schemaNs) + "/" + RESTUtils.encodeString(modelNs.level(2)) + "/models";
    }

    @VisibleForTesting
    static String formatModelVersionRequestPath(NameIdentifier modelIdent) {
        return GenericModelCatalog.formatModelRequestPath(modelIdent.namespace()) + "/" + RESTUtils.encodeString(modelIdent.name());
    }

    static class Builder
    extends CatalogDTO.Builder<Builder> {
        private RESTClient restClient;
        private Namespace namespace;

        private Builder() {
        }

        Builder withNamespace(Namespace namespace) {
            this.namespace = namespace;
            return this;
        }

        Builder withRestClient(RESTClient restClient) {
            this.restClient = restClient;
            return this;
        }

        @Override
        public GenericModelCatalog build() {
            Namespace.check(this.namespace != null && this.namespace.length() == 1, "Catalog namespace must be non-null and have 1 level, the input namespace is %s", this.namespace);
            Preconditions.checkArgument(StringUtils.isNotBlank(this.name), "name must not be blank");
            Preconditions.checkArgument(this.type != null, "type must not be null");
            Preconditions.checkArgument(StringUtils.isNotBlank(this.provider), "provider must not be blank");
            Preconditions.checkArgument(this.audit != null, "audit must not be null");
            Preconditions.checkArgument(this.restClient != null, "restClient must be set");
            return new GenericModelCatalog(this.namespace, this.name, this.type, this.provider, this.comment, this.properties, this.audit, this.restClient);
        }
    }
}

