/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.service.rest;

import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.gravitino.iceberg.service.IcebergExceptionMapper;
import org.apache.gravitino.iceberg.service.IcebergObjectMapper;
import org.apache.gravitino.iceberg.service.IcebergRestUtils;
import org.apache.gravitino.iceberg.service.dispatcher.IcebergNamespaceOperationDispatcher;
import org.apache.gravitino.listener.api.event.IcebergRequestContext;
import org.apache.gravitino.server.web.Utils;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.rest.RESTUtil;
import org.apache.iceberg.rest.requests.CreateNamespaceRequest;
import org.apache.iceberg.rest.requests.RegisterTableRequest;
import org.apache.iceberg.rest.requests.UpdateNamespacePropertiesRequest;
import org.apache.iceberg.rest.responses.CreateNamespaceResponse;
import org.apache.iceberg.rest.responses.GetNamespaceResponse;
import org.apache.iceberg.rest.responses.ListNamespacesResponse;
import org.apache.iceberg.rest.responses.LoadTableResponse;
import org.apache.iceberg.rest.responses.UpdateNamespacePropertiesResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/{prefix:([^/]*/)?}namespaces")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class IcebergNamespaceOperations {
    private static final Logger LOG = LoggerFactory.getLogger(IcebergNamespaceOperations.class);
    private ObjectMapper icebergObjectMapper;
    private IcebergNamespaceOperationDispatcher namespaceOperationDispatcher;
    @Context
    private HttpServletRequest httpRequest;

    @Inject
    public IcebergNamespaceOperations(IcebergNamespaceOperationDispatcher namespaceOperationDispatcher) {
        this.namespaceOperationDispatcher = namespaceOperationDispatcher;
        this.icebergObjectMapper = IcebergObjectMapper.getInstance();
    }

    @GET
    @Produces(value={"application/json"})
    @Timed(name="list-namespace.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="list-namespace", absolute=true)
    public Response listNamespaces(@DefaultValue(value="") @Encoded @QueryParam(value="parent") String parent, @PathParam(value="prefix") String prefix) {
        String catalogName = IcebergRestUtils.getCatalogName(prefix);
        Namespace parentNamespace = parent.isEmpty() ? Namespace.empty() : RESTUtil.decodeNamespace((String)parent);
        LOG.info("List Iceberg namespaces, catalog: {}, parentNamespace: {}", (Object)catalogName, (Object)parentNamespace);
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                IcebergRequestContext context = new IcebergRequestContext(this.httpServletRequest(), catalogName);
                ListNamespacesResponse response = this.namespaceOperationDispatcher.listNamespaces(context, parentNamespace);
                return IcebergRestUtils.ok(response);
            });
        }
        catch (Exception e) {
            return IcebergExceptionMapper.toRESTResponse(e);
        }
    }

    @GET
    @Path(value="{namespace}")
    @Produces(value={"application/json"})
    @Timed(name="load-namespace.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="load-namespace", absolute=true)
    public Response loadNamespace(@PathParam(value="prefix") String prefix, @Encoded @PathParam(value="namespace") String namespace) {
        String catalogName = IcebergRestUtils.getCatalogName(prefix);
        Namespace icebergNS = RESTUtil.decodeNamespace((String)namespace);
        LOG.info("Load Iceberg namespace, catalog: {}, namespace: {}", (Object)catalogName, (Object)icebergNS);
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                IcebergRequestContext context = new IcebergRequestContext(this.httpServletRequest(), catalogName);
                GetNamespaceResponse getNamespaceResponse = this.namespaceOperationDispatcher.loadNamespace(context, icebergNS);
                return IcebergRestUtils.ok(getNamespaceResponse);
            });
        }
        catch (Exception e) {
            return IcebergExceptionMapper.toRESTResponse(e);
        }
    }

    @HEAD
    @Path(value="{namespace}")
    @Produces(value={"application/json"})
    @Timed(name="namespace-exists.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="namespace-exists", absolute=true)
    public Response namespaceExists(@PathParam(value="prefix") String prefix, @Encoded @PathParam(value="namespace") String namespace) {
        String catalogName = IcebergRestUtils.getCatalogName(prefix);
        Namespace icebergNS = RESTUtil.decodeNamespace((String)namespace);
        LOG.info("Check Iceberg namespace exists, catalog: {}, namespace: {}", (Object)catalogName, (Object)icebergNS);
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                IcebergRequestContext context = new IcebergRequestContext(this.httpServletRequest(), catalogName);
                boolean exists = this.namespaceOperationDispatcher.namespaceExists(context, icebergNS);
                if (exists) {
                    return IcebergRestUtils.noContent();
                }
                return IcebergRestUtils.notExists();
            });
        }
        catch (Exception e) {
            return IcebergExceptionMapper.toRESTResponse(e);
        }
    }

    @DELETE
    @Path(value="{namespace}")
    @Produces(value={"application/json"})
    @Timed(name="drop-namespace.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="drop-namespace", absolute=true)
    public Response dropNamespace(@PathParam(value="prefix") String prefix, @Encoded @PathParam(value="namespace") String namespace) {
        String catalogName = IcebergRestUtils.getCatalogName(prefix);
        Namespace icebergNS = RESTUtil.decodeNamespace((String)namespace);
        LOG.info("Drop Iceberg namespace, catalog: {}, namespace: {}", (Object)catalogName, (Object)icebergNS);
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                IcebergRequestContext context = new IcebergRequestContext(this.httpServletRequest(), catalogName);
                this.namespaceOperationDispatcher.dropNamespace(context, icebergNS);
                return IcebergRestUtils.noContent();
            });
        }
        catch (Exception e) {
            return IcebergExceptionMapper.toRESTResponse(e);
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Timed(name="create-namespace.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="create-namespace", absolute=true)
    public Response createNamespace(@PathParam(value="prefix") String prefix, CreateNamespaceRequest createNamespaceRequest) {
        String catalogName = IcebergRestUtils.getCatalogName(prefix);
        LOG.info("Create Iceberg namespace, catalog: {}, createNamespaceRequest: {}", (Object)catalogName, (Object)createNamespaceRequest);
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                IcebergRequestContext context = new IcebergRequestContext(this.httpServletRequest(), catalogName);
                CreateNamespaceResponse createNamespaceResponse = this.namespaceOperationDispatcher.createNamespace(context, createNamespaceRequest);
                return IcebergRestUtils.ok(createNamespaceResponse);
            });
        }
        catch (Exception e) {
            return IcebergExceptionMapper.toRESTResponse(e);
        }
    }

    @POST
    @Path(value="{namespace}/properties")
    @Produces(value={"application/json"})
    @Timed(name="update-namespace.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="update-namespace", absolute=true)
    public Response updateNamespace(@PathParam(value="prefix") String prefix, @Encoded @PathParam(value="namespace") String namespace, UpdateNamespacePropertiesRequest updateNamespacePropertiesRequest) {
        String catalogName = IcebergRestUtils.getCatalogName(prefix);
        Namespace icebergNS = RESTUtil.decodeNamespace((String)namespace);
        LOG.info("Update Iceberg namespace, catalog: {}, namespace: {}, updateNamespacePropertiesRequest: {}", new Object[]{catalogName, icebergNS, this.SerializeUpdateNamespacePropertiesRequest(updateNamespacePropertiesRequest)});
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                IcebergRequestContext context = new IcebergRequestContext(this.httpServletRequest(), catalogName);
                UpdateNamespacePropertiesResponse updateNamespacePropertiesResponse = this.namespaceOperationDispatcher.updateNamespace(context, icebergNS, updateNamespacePropertiesRequest);
                return IcebergRestUtils.ok(updateNamespacePropertiesResponse);
            });
        }
        catch (Exception e) {
            return IcebergExceptionMapper.toRESTResponse(e);
        }
    }

    @POST
    @Path(value="{namespace}/register")
    @Produces(value={"application/json"})
    @Timed(name="register-table.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="register-table", absolute=true)
    public Response registerTable(@PathParam(value="prefix") String prefix, @Encoded @PathParam(value="namespace") String namespace, RegisterTableRequest registerTableRequest) {
        String catalogName = IcebergRestUtils.getCatalogName(prefix);
        Namespace icebergNS = RESTUtil.decodeNamespace((String)namespace);
        LOG.info("Register Iceberg table, catalog: {}, namespace: {}, registerTableRequest: {}", new Object[]{catalogName, icebergNS, registerTableRequest});
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                IcebergRequestContext context = new IcebergRequestContext(this.httpServletRequest(), catalogName);
                LoadTableResponse loadTableResponse = this.namespaceOperationDispatcher.registerTable(context, icebergNS, registerTableRequest);
                return IcebergRestUtils.ok(loadTableResponse);
            });
        }
        catch (Exception e) {
            return IcebergExceptionMapper.toRESTResponse(e);
        }
    }

    @VisibleForTesting
    HttpServletRequest httpServletRequest() {
        return this.httpRequest;
    }

    private String SerializeUpdateNamespacePropertiesRequest(UpdateNamespacePropertiesRequest updateNamespacePropertiesRequest) {
        try {
            return this.icebergObjectMapper.writeValueAsString((Object)updateNamespacePropertiesRequest);
        }
        catch (JsonProcessingException e) {
            LOG.warn("Serialize update namespace properties failed", (Throwable)e);
            return updateNamespacePropertiesRequest.toString();
        }
    }
}

