/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.servlet.support;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletException;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collections;
import java.util.EventListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.builder.ParentContextApplicationContextInitializer;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.boot.web.servlet.context.AnnotationConfigServletWebServerApplicationContext;
import org.springframework.boot.web.servlet.support.ErrorPageFilterConfiguration;
import org.springframework.boot.web.servlet.support.ServletContextApplicationContextInitializer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.web.WebApplicationInitializer;
import org.springframework.web.context.ConfigurableWebEnvironment;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import reactor.core.scheduler.Schedulers;

public abstract class SpringBootServletInitializer
implements WebApplicationInitializer {
    private static final boolean REACTOR_PRESENT = ClassUtils.isPresent("reactor.core.scheduler.Schedulers", SpringBootServletInitializer.class.getClassLoader());
    protected Log logger;
    private boolean registerErrorPageFilter = true;

    protected final void setRegisterErrorPageFilter(boolean registerErrorPageFilter) {
        this.registerErrorPageFilter = registerErrorPageFilter;
    }

    @Override
    public void onStartup(ServletContext servletContext) throws ServletException {
        servletContext.setAttribute("logging.register-shutdown-hook", (Object)false);
        this.logger = LogFactory.getLog(this.getClass());
        WebApplicationContext rootApplicationContext = this.createRootApplicationContext(servletContext);
        if (rootApplicationContext != null) {
            servletContext.addListener((EventListener)((Object)new SpringBootContextLoaderListener(rootApplicationContext, servletContext)));
        } else {
            this.logger.debug("No ContextLoaderListener registered, as createRootApplicationContext() did not return an application context");
        }
    }

    protected void deregisterJdbcDrivers(ServletContext servletContext) {
        for (Driver driver : Collections.list(DriverManager.getDrivers())) {
            if (driver.getClass().getClassLoader() != servletContext.getClassLoader()) continue;
            try {
                DriverManager.deregisterDriver(driver);
            }
            catch (SQLException sQLException) {}
        }
    }

    protected void shutDownSharedReactorSchedulers(ServletContext servletContext) {
        if (Schedulers.class.getClassLoader() == servletContext.getClassLoader()) {
            Schedulers.shutdownNow();
        }
    }

    protected WebApplicationContext createRootApplicationContext(ServletContext servletContext) {
        SpringApplicationBuilder builder = this.createSpringApplicationBuilder();
        builder.main(this.getClass());
        ApplicationContext parent = this.getExistingRootWebApplicationContext(servletContext);
        if (parent != null) {
            this.logger.info("Root context already created (using as parent).");
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, null);
            builder.initializers(new ParentContextApplicationContextInitializer(parent));
        }
        builder.initializers(new ServletContextApplicationContextInitializer(servletContext));
        builder.contextFactory(webApplicationType -> new AnnotationConfigServletWebServerApplicationContext());
        builder = this.configure(builder);
        builder.listeners(new WebEnvironmentPropertySourceInitializer(servletContext));
        SpringApplication application2 = builder.build();
        if (application2.getAllSources().isEmpty() && MergedAnnotations.from(this.getClass(), MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).isPresent(Configuration.class)) {
            application2.addPrimarySources(Collections.singleton(this.getClass()));
        }
        Assert.state(!application2.getAllSources().isEmpty(), "No SpringApplication sources have been defined. Either override the configure method or add an @Configuration annotation");
        if (this.registerErrorPageFilter) {
            application2.addPrimarySources(Collections.singleton(ErrorPageFilterConfiguration.class));
        }
        application2.setRegisterShutdownHook(false);
        return this.run(application2);
    }

    protected SpringApplicationBuilder createSpringApplicationBuilder() {
        return new SpringApplicationBuilder(new Class[0]);
    }

    protected WebApplicationContext run(SpringApplication application2) {
        return (WebApplicationContext)((Object)application2.run(new String[0]));
    }

    private ApplicationContext getExistingRootWebApplicationContext(ServletContext servletContext) {
        Object context = servletContext.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        if (context instanceof ApplicationContext) {
            ApplicationContext applicationContext = (ApplicationContext)context;
            return applicationContext;
        }
        return null;
    }

    protected SpringApplicationBuilder configure(SpringApplicationBuilder builder) {
        return builder;
    }

    private class SpringBootContextLoaderListener
    extends ContextLoaderListener {
        private final ServletContext servletContext;

        SpringBootContextLoaderListener(WebApplicationContext applicationContext, ServletContext servletContext) {
            super(applicationContext);
            this.servletContext = servletContext;
        }

        @Override
        public void contextInitialized(ServletContextEvent event) {
        }

        @Override
        public void contextDestroyed(ServletContextEvent event) {
            try {
                super.contextDestroyed(event);
            }
            finally {
                SpringBootServletInitializer.this.deregisterJdbcDrivers(this.servletContext);
                if (REACTOR_PRESENT) {
                    SpringBootServletInitializer.this.shutDownSharedReactorSchedulers(this.servletContext);
                }
            }
        }
    }

    private static final class WebEnvironmentPropertySourceInitializer
    implements ApplicationListener<ApplicationEnvironmentPreparedEvent>,
    Ordered {
        private final ServletContext servletContext;

        private WebEnvironmentPropertySourceInitializer(ServletContext servletContext) {
            this.servletContext = servletContext;
        }

        @Override
        public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
            ConfigurableEnvironment environment2 = event.getEnvironment();
            if (environment2 instanceof ConfigurableWebEnvironment) {
                ConfigurableWebEnvironment configurableWebEnvironment = (ConfigurableWebEnvironment)environment2;
                configurableWebEnvironment.initPropertySources(this.servletContext, null);
            }
        }

        @Override
        public int getOrder() {
            return Integer.MIN_VALUE;
        }
    }
}

