/*
 * Decompiled with CFR 0.152.
 */
package org.grails.plugins.i18n;

import grails.core.GrailsApplication;
import grails.plugins.GrailsPluginManager;
import grails.util.Environment;
import org.grails.spring.context.support.PluginAwareResourceBundleMessageSource;
import org.grails.web.i18n.ParamsAwareLocaleChangeInterceptor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.context.MessageSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.i18n.LocaleChangeInterceptor;
import org.springframework.web.servlet.i18n.SessionLocaleResolver;

@AutoConfiguration(before={MessageSourceAutoConfiguration.class, WebMvcAutoConfiguration.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class I18nAutoConfiguration {
    @Value(value="${grails.views.gsp.encoding:UTF-8}")
    private String encoding;
    @Value(value="${grails.gsp.enable.reload:false}")
    private boolean gspEnableReload;
    @Value(value="${grails.i18n.cache.seconds:5}")
    private int cacheSeconds;
    @Value(value="${grails.i18n.filecache.seconds:5}")
    private int fileCacheSeconds;

    @Bean(value={"localeResolver"})
    public LocaleResolver localeResolver() {
        return new SessionLocaleResolver();
    }

    @Bean
    public LocaleChangeInterceptor localeChangeInterceptor() {
        ParamsAwareLocaleChangeInterceptor localeChangeInterceptor = new ParamsAwareLocaleChangeInterceptor();
        localeChangeInterceptor.setParamName("lang");
        return localeChangeInterceptor;
    }

    @Bean(value={"messageSource"})
    public MessageSource messageSource(GrailsApplication grailsApplication, GrailsPluginManager pluginManager) {
        PluginAwareResourceBundleMessageSource messageSource = new PluginAwareResourceBundleMessageSource(grailsApplication, pluginManager);
        messageSource.setDefaultEncoding(this.encoding);
        messageSource.setFallbackToSystemLocale(false);
        if (Environment.getCurrent().isReloadEnabled() || this.gspEnableReload) {
            messageSource.setCacheSeconds(this.cacheSeconds);
            messageSource.setFileCacheSeconds(this.fileCacheSeconds);
        }
        return messageSource;
    }
}

