/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.util;

import io.micronaut.core.util.StringUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.grails.forge.application.Project;
import org.grails.forge.application.ProjectIdentifier;

public final class NameUtils {
    public static final String MICRONAUT = "micronaut";
    private static final String PROPERTY_SET_PREFIX = "set";
    private static final String PROPERTY_GET_PREFIX = "get";
    private static final Pattern SERVICE_ID_REGEX = Pattern.compile("[\\p{javaLowerCase}\\d-]+");

    private NameUtils() {
    }

    public static ProjectIdentifier parseProjectIdentifier(String name) throws IllegalArgumentException {
        String packageName;
        String appName;
        if (!NameUtils.isValidAppName(name)) {
            throw new IllegalArgumentException("\"" + name + "\" is not a valid app name");
        }
        String[] parts = name.split("\\.");
        if (parts.length == 1) {
            appName = parts[0];
            packageName = NameUtils.createPackageName(appName);
        } else {
            if (parts.length == 0) {
                throw new IllegalArgumentException("Cannot create a valid package name for [" + name + "]. Please specify a name that is also a valid Java package.");
            }
            int lastIdx = parts.length - 1;
            appName = parts[lastIdx];
            packageName = Arrays.stream(parts).limit(lastIdx).collect(Collectors.joining("."));
        }
        if (!NameUtils.isValidJavaPackage(packageName)) {
            throw new IllegalArgumentException("Cannot create a valid package name for [" + packageName + "]. Please specify a name that is also a valid Java package.");
        }
        if (!NameUtils.isValidAppName(appName)) {
            throw new IllegalArgumentException("\"" + appName + "\" is not a valid app name");
        }
        return new ProjectIdentifier(packageName, appName);
    }

    public static boolean isValidAppName(String appName) {
        return !StringUtils.isEmpty(appName) && !appName.equalsIgnoreCase(MICRONAUT);
    }

    public static Project parse(String name) throws IllegalArgumentException {
        ProjectIdentifier projectIdentifier = NameUtils.parseProjectIdentifier(name);
        String packageName = projectIdentifier.getPackageName();
        String appName = projectIdentifier.getName();
        String packagePath = packageName.replace('.', '/');
        String className = NameUtils.getNameFromScript(appName);
        String naturalName = NameUtils.getNaturalName(appName);
        String propertyName = NameUtils.getPropertyName(className);
        return new Project(packageName, packagePath, className, naturalName, propertyName, appName);
    }

    private static String createPackageName(String appName) {
        StringBuilder packageNameBuilder = new StringBuilder();
        for (char c : appName.toCharArray()) {
            if (c == '-') {
                packageNameBuilder.append('.');
            }
            if (!Character.isJavaIdentifierPart(c)) continue;
            packageNameBuilder.append(c);
        }
        return packageNameBuilder.toString();
    }

    public static boolean isValidServiceId(String name) {
        return name != null && name.length() > 0 && SERVICE_ID_REGEX.matcher(name).matches() && Character.isLetter(name.charAt(0));
    }

    public static String getSetterName(String propertyName) {
        String suffix = NameUtils.getSuffixForGetterOrSetter(propertyName);
        return PROPERTY_SET_PREFIX + suffix;
    }

    public static String getGetterName(String propertyName) {
        String suffix = NameUtils.getSuffixForGetterOrSetter(propertyName);
        return PROPERTY_GET_PREFIX + suffix;
    }

    private static String getSuffixForGetterOrSetter(String propertyName) {
        Object suffix = propertyName.length() > 1 && Character.isLowerCase(propertyName.charAt(0)) && Character.isUpperCase(propertyName.charAt(1)) ? propertyName : Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        return suffix;
    }

    public static String getClassName(String logicalName, String trailingName) {
        if (NameUtils.isBlank(logicalName)) {
            throw new IllegalArgumentException("Argument [logicalName] cannot be null or blank");
        }
        String className = logicalName.substring(0, 1).toUpperCase(Locale.ENGLISH) + logicalName.substring(1);
        if (trailingName != null) {
            className = className + trailingName;
        }
        return className;
    }

    public static String getFullClassName(Class cls) {
        String className = cls.getName();
        return NameUtils.getFullClassName(className);
    }

    public static String getFullClassName(String className) {
        int i2 = className.indexOf(36);
        if (i2 > -1) {
            className = className.substring(0, i2);
        }
        return className;
    }

    public static String getClassName(String logicalName) {
        return NameUtils.getClassName(logicalName, "");
    }

    public static String getClassNameRepresentation(String name) {
        String[] tokens;
        if (name == null || name.length() == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (String token1 : tokens = name.split("[^\\w\\d]")) {
            String token = token1.trim();
            int length = token.length();
            if (length <= 0) continue;
            buf.append(token.substring(0, 1).toUpperCase(Locale.ENGLISH));
            if (length <= 1) continue;
            buf.append(token.substring(1));
        }
        return buf.toString();
    }

    private static String getClassNameForLowerCaseHyphenSeparatedName(String name) {
        String[] tokens;
        if (NameUtils.isBlank(name)) {
            return name;
        }
        if (name.indexOf(45) == -1) {
            return name.substring(0, 1).toUpperCase() + name.substring(1);
        }
        StringBuilder buf = new StringBuilder();
        for (String token : tokens = name.split("-")) {
            if (token == null || token.length() == 0) continue;
            buf.append(token.substring(0, 1).toUpperCase()).append(token.substring(1));
        }
        return buf.toString();
    }

    public static String getLogicalName(Class<?> clazz, String trailingName) {
        return NameUtils.getLogicalName(clazz.getName(), trailingName);
    }

    public static String getLogicalName(String name, String trailingName) {
        if (NameUtils.isBlank(trailingName)) {
            return name;
        }
        String shortName = NameUtils.getShortName(name);
        if (!shortName.contains(trailingName)) {
            return name;
        }
        return shortName.substring(0, shortName.length() - trailingName.length());
    }

    public static String getLogicalPropertyName(String className, String trailingName) {
        if (!NameUtils.isBlank(className) && !NameUtils.isBlank(trailingName) && className.length() == trailingName.length() + 1 && className.endsWith(trailingName)) {
            return className.substring(0, 1).toLowerCase();
        }
        return NameUtils.getLogicalName(NameUtils.getPropertyName(className), trailingName);
    }

    public static String getPropertyName(String name) {
        return NameUtils.getPropertyNameRepresentation(name);
    }

    public static String getPropertyName(Class<?> clazz) {
        return NameUtils.getPropertyNameRepresentation(clazz);
    }

    public static String getPropertyNameRepresentation(Class<?> targetClass) {
        return NameUtils.getPropertyNameRepresentation(NameUtils.getShortName(targetClass));
    }

    public static String getPropertyNameRepresentation(String name) {
        int pos = name.lastIndexOf(46);
        if (pos != -1) {
            name = name.substring(pos + 1);
        }
        if (name.isEmpty()) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(0)) && Character.isUpperCase(name.charAt(1))) {
            return name;
        }
        Object propertyName = name.substring(0, 1).toLowerCase(Locale.ENGLISH) + name.substring(1);
        if (((String)propertyName).indexOf(32) > -1) {
            propertyName = ((String)propertyName).replaceAll("\\s", "");
        }
        return propertyName;
    }

    public static String getPropertyNameForLowerCaseHyphenSeparatedName(String name) {
        return NameUtils.getPropertyName(NameUtils.getClassNameForLowerCaseHyphenSeparatedName(name));
    }

    public static String getShortName(Class<?> targetClass) {
        return NameUtils.getShortName(targetClass.getName());
    }

    public static String getShortName(String className) {
        int i2 = className.lastIndexOf(".");
        if (i2 > -1) {
            className = className.substring(i2 + 1);
        }
        return className;
    }

    public static String getPackageName(String className) {
        int i2 = className.lastIndexOf(".");
        String packageName = "";
        if (i2 > -1) {
            packageName = className.substring(0, i2);
        }
        return packageName.toLowerCase();
    }

    public static String getScriptName(Class<?> clazz) {
        return clazz == null ? null : NameUtils.getScriptName(clazz.getName());
    }

    public static String getScriptName(String name) {
        if (name == null) {
            return null;
        }
        if (name.endsWith(".groovy")) {
            name = name.substring(0, name.length() - 7);
        }
        return NameUtils.getNaturalName(name).replaceAll("\\s", "-").toLowerCase();
    }

    public static String getNameFromScript(String scriptName) {
        return NameUtils.getClassNameForLowerCaseHyphenSeparatedName(scriptName);
    }

    public static String getPluginName(String descriptorName) {
        if (descriptorName == null || descriptorName.length() == 0) {
            return descriptorName;
        }
        if (!descriptorName.endsWith("GrailsPlugin.groovy")) {
            throw new IllegalArgumentException("Plugin descriptor name is not valid: " + descriptorName);
        }
        return NameUtils.getScriptName(descriptorName.substring(0, descriptorName.indexOf("GrailsPlugin.groovy")));
    }

    public static String getNaturalName(String name) {
        if (NameUtils.isBlank(name = NameUtils.getShortName(name))) {
            return name;
        }
        if (name.length() == 1) {
            return name.toUpperCase();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(name.charAt(name.length() - 1));
        for (int i2 = name.length() - 2; i2 > 0; --i2) {
            char currChar = name.charAt(i2);
            char prevChar = name.charAt(i2 - 1);
            char nextChar = name.charAt(i2 + 1);
            boolean isCurrentCharLowerCase = Character.isLowerCase(currChar);
            boolean isPrevCharLowerCase = Character.isLowerCase(prevChar);
            boolean isNextCharLowerCase = Character.isLowerCase(nextChar);
            if (isCurrentCharLowerCase != isPrevCharLowerCase && !isCurrentCharLowerCase) {
                sb.append(currChar).append(" ");
                continue;
            }
            if (isCurrentCharLowerCase == isPrevCharLowerCase && !isCurrentCharLowerCase && isNextCharLowerCase) {
                sb.append(currChar).append(" ");
                continue;
            }
            sb.append(currChar);
        }
        sb.append(Character.toUpperCase(name.charAt(0)));
        return sb.reverse().toString();
    }

    public static String getNaturalNameOfEnum(String name) {
        return NameUtils.getNaturalName(io.micronaut.core.naming.NameUtils.camelCase(name.toLowerCase()));
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isValidJavaPackage(String packageName) {
        String[] parts;
        if (NameUtils.isBlank(packageName)) {
            return false;
        }
        for (String part : parts = packageName.split("\\.")) {
            if (NameUtils.isValidJavaIdentifier(part)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidJavaIdentifier(String name) {
        if (NameUtils.isBlank(name)) {
            return false;
        }
        char[] chars = name.toCharArray();
        if (!Character.isJavaIdentifierStart(chars[0])) {
            return false;
        }
        for (char c : chars) {
            if (Character.isJavaIdentifierPart(c)) continue;
            return false;
        }
        return true;
    }

    public static String getPropertyNameConvention(Object object, String suffix) {
        if (object != null) {
            Class<?> type = object.getClass();
            if (type.isArray()) {
                return NameUtils.getPropertyName(type.getComponentType()) + suffix + "Array";
            }
            if (object instanceof Collection) {
                Collection coll = (Collection)object;
                if (coll.isEmpty()) {
                    return "emptyCollection";
                }
                Object first = coll.iterator().next();
                if (coll instanceof List) {
                    return NameUtils.getPropertyName(first.getClass()) + suffix + "List";
                }
                if (coll instanceof Set) {
                    return NameUtils.getPropertyName(first.getClass()) + suffix + "Set";
                }
                return NameUtils.getPropertyName(first.getClass()) + suffix + "Collection";
            }
            if (object instanceof Map) {
                Map map = (Map)object;
                if (map.isEmpty()) {
                    return "emptyMap";
                }
                Object entry = map.values().iterator().next();
                if (entry != null) {
                    return NameUtils.getPropertyName(entry.getClass()) + suffix + "Map";
                }
            } else {
                return NameUtils.getPropertyName(object.getClass()) + suffix;
            }
        }
        return null;
    }

    public static String getPropertyForGetter(String getterName) {
        return NameUtils.getPropertyForGetter(getterName, Boolean.TYPE);
    }

    public static String getPropertyForGetter(String getterName, Class returnType) {
        if (getterName == null || getterName.length() == 0) {
            return null;
        }
        if (getterName.startsWith(PROPERTY_GET_PREFIX)) {
            String prop = getterName.substring(3);
            return NameUtils.convertValidPropertyMethodSuffix(prop);
        }
        if (getterName.startsWith("is") && returnType == Boolean.TYPE) {
            String prop = getterName.substring(2);
            return NameUtils.convertValidPropertyMethodSuffix(prop);
        }
        return null;
    }

    static String convertValidPropertyMethodSuffix(String suffix) {
        if (suffix.length() == 0) {
            return null;
        }
        if (!Character.isJavaIdentifierStart(suffix.charAt(0))) {
            return null;
        }
        if (suffix.length() == 1) {
            return Character.isUpperCase(suffix.charAt(0)) ? suffix.toLowerCase() : null;
        }
        if (Character.isUpperCase(suffix.charAt(1))) {
            return suffix;
        }
        if (Character.isUpperCase(suffix.charAt(0))) {
            return Character.toLowerCase(suffix.charAt(0)) + suffix.substring(1);
        }
        if ('_' == suffix.charAt(0)) {
            return suffix;
        }
        return null;
    }

    @Deprecated
    public static boolean isGetter(String name, Class<?>[] args) {
        return NameUtils.isGetter(name, Boolean.TYPE, args);
    }

    public static boolean isGetter(String name, Class returnType, Class<?>[] args) {
        if (name == null || name.length() == 0 || args == null) {
            return false;
        }
        if (args.length != 0) {
            return false;
        }
        if (name.startsWith(PROPERTY_GET_PREFIX)) {
            name = name.substring(3);
            return NameUtils.isPropertyMethodSuffix(name);
        }
        if (name.startsWith("is") && returnType == Boolean.TYPE) {
            name = name.substring(2);
            return NameUtils.isPropertyMethodSuffix(name);
        }
        return false;
    }

    protected static boolean isPropertyMethodSuffix(String suffix) {
        if (suffix.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(suffix.charAt(0))) {
            return false;
        }
        if (suffix.length() == 1) {
            return Character.isUpperCase(suffix.charAt(0));
        }
        return Character.isUpperCase(suffix.charAt(0)) || Character.isUpperCase(suffix.charAt(1));
    }

    public static String getPropertyForSetter(String setterName) {
        if (setterName == null || setterName.length() == 0) {
            return null;
        }
        if (setterName.startsWith(PROPERTY_SET_PREFIX)) {
            String prop = setterName.substring(3);
            return NameUtils.convertValidPropertyMethodSuffix(prop);
        }
        return null;
    }
}

