/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.build.dependencies;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.core.util.StringUtils;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.grails.forge.build.dependencies.Coordinate;
import org.grails.forge.build.dependencies.CoordinateResolver;
import org.grails.forge.build.dependencies.Dependency;
import org.grails.forge.build.dependencies.DependencyCoordinate;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Singleton
public class PomDependencyVersionResolver
implements CoordinateResolver {
    private static final String NODE_NAME_TEXT = "#text";
    private final Map<String, Coordinate> coordinates;

    public PomDependencyVersionResolver(ResourceResolver resourceResolver) {
        HashMap<String, Coordinate> coordinates = new HashMap<String, Coordinate>();
        for (URL url : resourceResolver.getResources("classpath:pom.xml").collect(Collectors.toList())) {
            try {
                InputStream inputStream = url.openStream();
                Document doc = PomDependencyVersionResolver.documentFor(inputStream);
                doc.getDocumentElement().normalize();
                NodeList nList = doc.getElementsByTagName("dependency");
                for (int i2 = 0; i2 < nList.getLength(); ++i2) {
                    Node node = nList.item(i2);
                    NodeList childNodes = node.getChildNodes();
                    String groupId = null;
                    String artifactId = null;
                    String version = null;
                    boolean pom = false;
                    for (int x = 0; x < childNodes.getLength(); ++x) {
                        Node child = childNodes.item(x);
                        if (child.getNodeName().equals("version") && this.valueOfNode(child).isPresent()) {
                            version = this.valueOfNode(child).get();
                        }
                        if (child.getNodeName().equals("groupId") && this.valueOfNode(child).isPresent()) {
                            groupId = this.valueOfNode(child).get();
                        }
                        if (child.getNodeName().equals("artifactId") && this.valueOfNode(child).isPresent()) {
                            artifactId = this.valueOfNode(child).get();
                        }
                        if (!child.getNodeName().equals("type") || !this.valueOfNode(child).isPresent()) continue;
                        pom = "pom".equalsIgnoreCase(this.valueOfNode(child).get());
                    }
                    if (!StringUtils.isNotEmpty(groupId) || !StringUtils.isNotEmpty(artifactId)) continue;
                    DependencyCoordinate dependencyCoordinate = Dependency.builder().groupId(groupId).artifactId(artifactId).version(version).pom(pom).buildCoordinate();
                    coordinates.put(dependencyCoordinate.getArtifactId(), dependencyCoordinate);
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                e.printStackTrace();
            }
        }
        this.coordinates = coordinates;
    }

    @Override
    @NonNull
    public Optional<Coordinate> resolve(@NonNull String artifactId) {
        return Optional.ofNullable(this.coordinates.get(artifactId));
    }

    private static Document documentFor(@NonNull InputStream inputStream) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        return dBuilder.parse(inputStream);
    }

    @NonNull
    private Optional<String> valueOfNode(@NonNull Node node) {
        NodeList children = node.getChildNodes();
        for (int i2 = 0; i2 < children.getLength(); ++i2) {
            Node child = children.item(i2);
            if (!child.getNodeName().equals(NODE_NAME_TEXT)) continue;
            return Optional.of(child.getNodeValue());
        }
        return Optional.empty();
    }

    @NonNull
    public Map<String, Coordinate> getCoordinates() {
        return this.coordinates;
    }
}

