/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.netty.implementation;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import reactor.netty.Connection;
import reactor.netty.channel.ChannelOperations;

public final class Utility {
    public static ByteBuffer deepCopyBuffer(ByteBuf byteBuf) {
        ByteBuffer buffer = ByteBuffer.allocate(byteBuf.readableBytes());
        byteBuf.readBytes(buffer);
        buffer.rewind();
        return buffer;
    }

    public static void closeConnection(Connection reactorNettyConnection) {
        if (reactorNettyConnection instanceof ChannelOperations) {
            ChannelOperations channelOperations = (ChannelOperations)reactorNettyConnection;
            if (!channelOperations.isInboundDisposed()) {
                channelOperations.channel().eventLoop().execute(() -> ((ChannelOperations)channelOperations).discard());
            }
        } else if (!reactorNettyConnection.isDisposed()) {
            reactorNettyConnection.channel().eventLoop().execute(() -> ((Connection)reactorNettyConnection).dispose());
        }
    }

    private Utility() {
    }
}

