/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.task.statemachine;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.server.master.engine.task.statemachine.ITaskStateAction;
import org.springframework.stereotype.Component;

@Component
public class TaskStateActionFactory {
    private final Map<TaskExecutionStatus, ITaskStateAction> taskStateActionMap = new HashMap<TaskExecutionStatus, ITaskStateAction>();

    public TaskStateActionFactory(List<ITaskStateAction> taskStateActions) {
        taskStateActions.forEach(taskStateAction -> this.taskStateActionMap.put(taskStateAction.matchState(), (ITaskStateAction)taskStateAction));
        Arrays.stream(TaskExecutionStatus.values()).forEach(this::getTaskStateAction);
    }

    public ITaskStateAction getTaskStateAction(TaskExecutionStatus taskExecutionStatus) {
        ITaskStateAction taskStateAction = this.taskStateActionMap.get(taskExecutionStatus);
        if (taskStateAction == null) {
            throw new IllegalArgumentException("Cannot find TaskStateAction for state: " + taskExecutionStatus);
        }
        return taskStateAction;
    }
}

