/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.task.client;

import com.google.common.base.Preconditions;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.extract.base.client.Clients;
import org.apache.dolphinscheduler.extract.master.ILogicTaskExecutorOperator;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.engine.exceptions.TaskKillException;
import org.apache.dolphinscheduler.server.master.engine.task.client.ITaskExecutorClientDelegator;
import org.apache.dolphinscheduler.server.master.engine.task.runnable.ITaskExecutionRunnable;
import org.apache.dolphinscheduler.server.master.exception.dispatch.TaskDispatchException;
import org.apache.dolphinscheduler.task.executor.eventbus.ITaskExecutorLifecycleEventReporter;
import org.apache.dolphinscheduler.task.executor.operations.TaskExecutorDispatchRequest;
import org.apache.dolphinscheduler.task.executor.operations.TaskExecutorDispatchResponse;
import org.apache.dolphinscheduler.task.executor.operations.TaskExecutorKillRequest;
import org.apache.dolphinscheduler.task.executor.operations.TaskExecutorKillResponse;
import org.apache.dolphinscheduler.task.executor.operations.TaskExecutorPauseRequest;
import org.apache.dolphinscheduler.task.executor.operations.TaskExecutorPauseResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LogicTaskExecutorClientDelegator
implements ITaskExecutorClientDelegator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogicTaskExecutorClientDelegator.class);
    @Autowired
    private MasterConfig masterConfig;

    @Override
    public void dispatch(ITaskExecutionRunnable taskExecutionRunnable) throws TaskDispatchException {
        String logicTaskExecutorAddress = this.masterConfig.getMasterAddress();
        TaskExecutionContext taskExecutionContext = taskExecutionRunnable.getTaskExecutionContext();
        taskExecutionContext.setHost(logicTaskExecutorAddress);
        taskExecutionRunnable.getTaskInstance().setHost(logicTaskExecutorAddress);
        TaskExecutorDispatchResponse logicTaskDispatchResponse = ((ILogicTaskExecutorOperator)Clients.withService(ILogicTaskExecutorOperator.class).withHost(logicTaskExecutorAddress)).dispatchTask(TaskExecutorDispatchRequest.of((TaskExecutionContext)taskExecutionContext));
        if (!logicTaskDispatchResponse.isDispatchSuccess()) {
            throw new TaskDispatchException(String.format("Dispatch LogicTask to %s failed, response is: %s", taskExecutionContext.getHost(), logicTaskDispatchResponse));
        }
    }

    @Override
    public boolean reassignMasterHost(ITaskExecutionRunnable taskExecutionRunnable) {
        return false;
    }

    @Override
    public void pause(ITaskExecutionRunnable taskExecutionRunnable) {
        TaskInstance taskInstance = taskExecutionRunnable.getTaskInstance();
        String executorHost = taskInstance.getHost();
        String taskName = taskInstance.getName();
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)executorHost), (Object)"Executor host is empty");
        TaskExecutorPauseResponse pauseResponse = ((ILogicTaskExecutorOperator)Clients.withService(ILogicTaskExecutorOperator.class).withHost(taskInstance.getHost())).pauseTask(TaskExecutorPauseRequest.of((Integer)taskInstance.getId()));
        if (pauseResponse.isSuccess()) {
            log.info("Pause task {} on executor {} successfully", (Object)taskName, (Object)executorHost);
        } else {
            log.warn("Pause task {} on executor {} failed with response {}", new Object[]{taskName, executorHost, pauseResponse});
        }
    }

    @Override
    public void kill(ITaskExecutionRunnable taskExecutionRunnable) throws TaskKillException {
        TaskInstance taskInstance = taskExecutionRunnable.getTaskInstance();
        String executorHost = taskInstance.getHost();
        String taskName = taskInstance.getName();
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)executorHost), (Object)"Executor host is empty");
        TaskExecutorKillResponse killResponse = ((ILogicTaskExecutorOperator)Clients.withService(ILogicTaskExecutorOperator.class).withHost(taskInstance.getHost())).killTask(TaskExecutorKillRequest.of((Integer)taskInstance.getId()));
        if (killResponse.isSuccess()) {
            log.info("Kill task {} on executor {} successfully", (Object)taskName, (Object)executorHost);
        } else {
            log.warn("Kill task {} on executor {} failed with response {}", new Object[]{taskName, executorHost, killResponse});
        }
    }

    @Override
    public void ackTaskExecutorLifecycleEvent(ITaskExecutionRunnable taskExecutionRunnable, ITaskExecutorLifecycleEventReporter.TaskExecutorLifecycleEventAck taskExecutorLifecycleEventAck) {
        TaskInstance taskInstance = taskExecutionRunnable.getTaskInstance();
        String executorHost = taskInstance.getHost();
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)executorHost), (Object)"Executor host is empty");
        ((ILogicTaskExecutorOperator)Clients.withService(ILogicTaskExecutorOperator.class).withHost(taskInstance.getHost())).ackTaskExecutorLifecycleEvent(taskExecutorLifecycleEventAck);
    }
}

