/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.msi.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.msi.fluent.models.UserAssignedIdentityProperties;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.UUID;

public final class IdentityUpdate
extends ProxyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(IdentityUpdate.class);
    @JsonProperty(value="location")
    private String location;
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> tags;
    @JsonProperty(value="properties", access=JsonProperty.Access.WRITE_ONLY)
    private UserAssignedIdentityProperties innerProperties;

    public String location() {
        return this.location;
    }

    public IdentityUpdate withLocation(String location) {
        this.location = location;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public IdentityUpdate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    private UserAssignedIdentityProperties innerProperties() {
        return this.innerProperties;
    }

    public UUID tenantId() {
        return this.innerProperties() == null ? null : this.innerProperties().tenantId();
    }

    public UUID principalId() {
        return this.innerProperties() == null ? null : this.innerProperties().principalId();
    }

    public UUID clientId() {
        return this.innerProperties() == null ? null : this.innerProperties().clientId();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

