/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.command;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.micrometer.core.annotation.Counted;
import java.io.Serializable;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.Command;
import org.apache.dolphinscheduler.dao.entity.ErrorCommand;
import org.apache.dolphinscheduler.dao.entity.Schedule;
import org.apache.dolphinscheduler.dao.mapper.CommandMapper;
import org.apache.dolphinscheduler.dao.mapper.ErrorCommandMapper;
import org.apache.dolphinscheduler.dao.mapper.ScheduleMapper;
import org.apache.dolphinscheduler.service.command.CommandService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CommandServiceImpl
implements CommandService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommandServiceImpl.class);
    @Autowired
    private ErrorCommandMapper errorCommandMapper;
    @Autowired
    private CommandMapper commandMapper;
    @Autowired
    private ScheduleMapper scheduleMapper;

    @Override
    public void moveToErrorCommand(Command command, String message) {
        ErrorCommand errorCommand = new ErrorCommand(command, message);
        this.errorCommandMapper.insert((Object)errorCommand);
        this.commandMapper.deleteById((Serializable)command.getId());
    }

    @Override
    @Counted(value="ds.workflow.create.command.count")
    public int createCommand(Command command) {
        int result = 0;
        if (command == null) {
            return result;
        }
        Schedule schedule = this.scheduleMapper.queryByWorkflowDefinitionCode(command.getWorkflowDefinitionCode());
        if (schedule != null) {
            Map<String, String> commandParams = StringUtils.isNotBlank((CharSequence)command.getCommandParam()) ? JSONUtils.toMap((String)command.getCommandParam()) : new HashMap();
            commandParams.put("schedule_timezone", schedule.getTimezoneId());
            command.setCommandParam(JSONUtils.toJsonString(commandParams));
        }
        command.setId(null);
        result = this.commandMapper.insert((Object)command);
        return result;
    }

    @Override
    public boolean verifyIsNeedCreateCommand(Command command) {
        boolean isNeedCreate = true;
        EnumMap<CommandType, Integer> cmdTypeMap = new EnumMap<CommandType, Integer>(CommandType.class);
        cmdTypeMap.put(CommandType.REPEAT_RUNNING, 1);
        cmdTypeMap.put(CommandType.RECOVER_SUSPENDED_PROCESS, 1);
        cmdTypeMap.put(CommandType.START_FAILURE_TASK_PROCESS, 1);
        CommandType commandType = command.getCommandType();
        if (!cmdTypeMap.containsKey(commandType)) {
            return true;
        }
        ObjectNode cmdParamObj = JSONUtils.parseObject((String)command.getCommandParam());
        int processInstanceId = cmdParamObj.path("ProcessInstanceId").asInt();
        List commands = this.commandMapper.selectList(null);
        for (Command tmpCommand : commands) {
            ObjectNode tempObj;
            if (!cmdTypeMap.containsKey(tmpCommand.getCommandType()) || (tempObj = JSONUtils.parseObject((String)tmpCommand.getCommandParam())) == null || processInstanceId != tempObj.path("ProcessInstanceId").asInt()) continue;
            isNeedCreate = false;
            break;
        }
        return isNeedCreate;
    }
}

