/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.fluent.models.ServiceDelegationPropertiesFormat;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class Delegation
extends SubResource {
    @JsonProperty(value="properties")
    private ServiceDelegationPropertiesFormat innerProperties;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="type")
    private String type;

    private ServiceDelegationPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public Delegation withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public String type() {
        return this.type;
    }

    public Delegation withType(String type) {
        this.type = type;
        return this;
    }

    public Delegation withId(String id) {
        super.withId(id);
        return this;
    }

    public String serviceName() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceName();
    }

    public Delegation withServiceName(String serviceName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServiceDelegationPropertiesFormat();
        }
        this.innerProperties().withServiceName(serviceName);
        return this;
    }

    public List<String> actions() {
        return this.innerProperties() == null ? null : this.innerProperties().actions();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

