/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.util;

import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Typed;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.configurator.BeanConfigurator;
import jakarta.inject.Named;
import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

public class BeanConfiguratorUtils {
    private BeanConfiguratorUtils() {
    }

    public static <T> BeanConfigurator<T> read(BeanManager beanManager, BeanConfigurator<T> beanConfigurator, AnnotatedType<T> type) {
        if (!type.getJavaClass().isInterface()) {
            return beanConfigurator.read(type);
        }
        boolean qualifierAdded = false;
        for (Annotation annotation : type.getAnnotations()) {
            if (beanManager.isQualifier(annotation.annotationType())) {
                beanConfigurator.addQualifier(annotation);
                qualifierAdded = true;
            } else if (beanManager.isScope(annotation.annotationType())) {
                beanConfigurator.scope(annotation.annotationType());
            } else if (beanManager.isStereotype(annotation.annotationType())) {
                beanConfigurator.addStereotype(annotation.annotationType());
            }
            if (!(annotation instanceof Named)) continue;
            String name = ((Named)annotation).value();
            if (name == null || name.isBlank()) {
                name = Introspector.decapitalize(type.getJavaClass().getSimpleName());
            }
            beanConfigurator.name(name);
        }
        if (type.isAnnotationPresent(Typed.class)) {
            Typed typed = (Typed)type.getAnnotation(Typed.class);
            beanConfigurator.types((Type[])typed.value());
        } else {
            for (Class c = type.getJavaClass(); c != Object.class && c != null; c = c.getSuperclass()) {
                beanConfigurator.addTypes(new Type[]{c});
            }
            beanConfigurator.addTypes((Type[])type.getJavaClass().getInterfaces());
            beanConfigurator.addTypes(new Type[]{Object.class});
        }
        if (!qualifierAdded) {
            beanConfigurator.addQualifier((Annotation)Default.Literal.INSTANCE);
        }
        beanConfigurator.addQualifier((Annotation)Any.Literal.INSTANCE);
        return beanConfigurator;
    }
}

