/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.io;

import com.terracottatech.frs.io.AbstractChunk;
import com.terracottatech.frs.io.BufferSource;
import com.terracottatech.frs.io.Chunk;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;

public class FileBuffer
extends AbstractChunk
implements Closeable {
    protected final FileChannel channel;
    protected final BufferSource source;
    protected final ByteBuffer base;
    protected ByteBuffer[] ref;
    private int mark = 0;
    private long total = 0L;
    private long offset = 0L;

    public FileBuffer(FileChannel channel, ByteBuffer src) throws IOException {
        if (src.position() != 0) {
            throw new AssertionError();
        }
        if (src.capacity() < 512) {
            // empty if block
        }
        this.channel = channel;
        this.base = src;
        this.source = null;
        this.ref = new ByteBuffer[]{this.base.duplicate()};
        this.offset = 0L;
    }

    public FileBuffer(FileChannel channel, BufferSource src, int size) throws IOException {
        this.channel = channel;
        this.source = src;
        this.base = src.getBuffer(size);
        this.ref = new ByteBuffer[]{this.base.duplicate()};
        this.offset = 0L;
    }

    public long getTotal() {
        return this.total;
    }

    @Override
    public ByteBuffer[] getBuffers() {
        return this.ref;
    }

    @Override
    public long position() {
        return this.offset + super.position();
    }

    public long offset() {
        return this.offset;
    }

    public long size() throws IOException {
        return this.channel.size();
    }

    public int capacity() {
        return this.base.limit();
    }

    public void bufferMove(int src, int dest, int length) {
        ByteBuffer from = (ByteBuffer)this.base.duplicate().position(src).limit(src + length);
        ByteBuffer to = (ByteBuffer)this.base.duplicate().position(dest).limit(dest + length);
        to.put(from);
    }

    public FileBuffer position(long pos) throws IOException {
        if (pos < 0L) {
            this.channel.position(this.channel.size() + pos);
        } else {
            this.channel.position(pos);
        }
        this.offset = this.channel.position() - super.position();
        return this;
    }

    public FileBuffer partition(int ... pos) {
        ByteBuffer target = this.base.duplicate();
        ArrayList<ByteBuffer> sections = new ArrayList<ByteBuffer>();
        for (int p : pos) {
            if (p > target.limit()) {
                throw new BufferUnderflowException();
            }
            target.limit(p + target.position());
            sections.add(target.slice());
            target.clear().position(target.position() + p);
        }
        sections.add(target.slice());
        this.ref = sections.toArray(new ByteBuffer[sections.size()]);
        this.mark = 0;
        return this;
    }

    @Override
    public void clear() {
        this.ref = new ByteBuffer[]{this.base.duplicate()};
        this.mark = 0;
    }

    public long read(int count) throws IOException {
        int x;
        long lt = 0L;
        if (this.mark == 0) {
            this.offset = this.channel.position();
        }
        for (x = this.mark; x < this.mark + count; ++x) {
            if (this.ref[x].isReadOnly()) {
                this.ref[x] = this.ref[x].duplicate();
                this.ref[x].limit(this.ref[x].position());
                continue;
            }
            assert (this.ref[x].position() == 0);
        }
        while (this.ref[this.mark + count - 1].hasRemaining()) {
            long read = this.channel.read(this.ref, this.mark, count);
            if (read < 0L) {
                throw new EOFException(lt + " " + read + " " + this.mark + " " + count);
            }
            lt += read;
        }
        for (x = this.mark; x < this.mark + count; ++x) {
            this.ref[x].flip();
        }
        this.mark += count;
        this.total += lt;
        return lt;
    }

    public long truncate() {
        long lt = 0L;
        for (int x = this.mark; x < this.ref.length; ++x) {
            lt += (long)this.ref[x].limit(this.ref[x].position()).position();
        }
        return lt;
    }

    public long writeFully(ByteBuffer buffer) throws IOException {
        long lt = 0L;
        while (buffer.hasRemaining()) {
            lt += (long)this.channel.write(buffer);
        }
        this.offset = this.channel.position();
        return lt;
    }

    private ByteBuffer coalesce(ByteBuffer scratch, ByteBuffer[] list, int start, int count) {
        if (count == 1 && (scratch.isDirect() == list[start].isDirect() || list[start].remaining() > scratch.remaining())) {
            return list[start];
        }
        scratch.clear();
        for (int x = start; x < start + count; ++x) {
            if (list[x].remaining() > scratch.remaining()) {
                if (count == 1) {
                    return list[x];
                }
                throw new AssertionError((Object)"no space");
            }
            scratch.put(list[x]);
        }
        scratch.flip();
        return scratch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long coalescingWrite(int usage, int count) throws IOException {
        int smStart = -1;
        long lt = 0L;
        try {
            ByteBuffer memcpy = ((ByteBuffer)this.base.position(usage)).slice();
            int currentRun = 0;
            for (int x = this.mark; x < this.mark + count; ++x) {
                if (this.ref[x].isDirect() && this.ref[x].remaining() > 512) {
                    if (smStart >= 0) {
                        lt += this.writeFully(this.coalesce(memcpy, this.ref, smStart, x - smStart));
                        smStart = -1;
                        currentRun = 0;
                    }
                    lt += this.writeFully(this.coalesce(memcpy, this.ref, x, 1));
                    continue;
                }
                if (currentRun + this.ref[x].remaining() > memcpy.capacity()) {
                    if (smStart < 0) {
                        lt += this.writeFully(this.coalesce(memcpy, this.ref, x, 1));
                        continue;
                    }
                    lt += this.writeFully(this.coalesce(memcpy, this.ref, smStart, x - smStart));
                    smStart = x;
                    currentRun = this.ref[x].remaining();
                    continue;
                }
                if (smStart < 0) {
                    smStart = x;
                }
                currentRun += this.ref[x].remaining();
            }
            if (smStart >= 0) {
                lt += this.writeFully(this.coalesce(memcpy, this.ref, smStart, this.mark + count - smStart));
            }
        }
        finally {
            this.base.position(0);
        }
        return lt;
    }

    public long write(int count) throws IOException {
        int x;
        long lt = 0L;
        int usage = 0;
        boolean direct = true;
        for (x = this.mark; x < this.mark + count; ++x) {
            if (this.ref[x].isReadOnly()) continue;
            usage += this.ref[x].position();
            if (!this.ref[x].isDirect()) {
                direct = false;
            }
            this.ref[x].flip();
        }
        if (count > 5 || !direct) {
            lt += this.coalescingWrite(usage, count);
        } else {
            for (x = this.mark; x < count; ++x) {
                lt += this.writeFully(this.ref[x]);
            }
        }
        this.mark += count;
        this.total += lt;
        return lt;
    }

    @Override
    public Chunk getChunk(long length) {
        if (this.remaining() < length) {
            return super.getChunk(length);
        }
        try {
            return new CloseableChunk(this.position(), length);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public void insert(ByteBuffer[] bufs, int loc, boolean writable) throws IOException {
        int len = this.ref.length;
        this.ref = Arrays.copyOf(this.ref, this.ref.length + bufs.length);
        System.arraycopy(this.ref, loc, this.ref, loc + bufs.length, len - loc);
        for (int x = 0; x < bufs.length; ++x) {
            this.ref[loc + x] = writable ? bufs[x] : bufs[x].asReadOnlyBuffer();
        }
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
        if (this.source != null) {
            this.source.returnBuffer(this.base);
        }
        this.ref = null;
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public void sync(boolean meta) throws IOException {
        this.channel.force(meta);
    }

    public String toString() {
        return "FileBuffer{channel=" + this.channel.toString() + '}';
    }

    public FileChannel getFileChannel() {
        return this.channel;
    }

    private class CloseableChunk
    extends AbstractChunk
    implements Closeable {
        private final ByteBuffer[] data;

        public CloseableChunk(long start, long length) throws IOException {
            if (FileBuffer.this.source == null) {
                throw new IOException("no buffer space");
            }
            if (length > Integer.MAX_VALUE) {
                throw new IOException("buffer overflow");
            }
            this.data = new ByteBuffer[]{FileBuffer.this.source.getBuffer((int)length)};
            if (this.data[0] == null) {
                throw new IOException("no buffer space");
            }
            FileBuffer.this.channel.position(start);
            while (this.data[0].hasRemaining()) {
                if (FileBuffer.this.channel.read(this.data) >= 0L) continue;
                throw new EOFException();
            }
        }

        @Override
        public ByteBuffer[] getBuffers() {
            return this.data;
        }

        @Override
        public void close() throws IOException {
            FileBuffer.this.source.returnBuffer(this.data[0]);
        }
    }
}

