/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.cluster.ha;

import java.util.Map;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.server.cluster.ha.HAPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.ScaleDownPolicy;
import org.apache.activemq.artemis.core.server.impl.Activation;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.PrimaryOnlyActivation;

public class PrimaryOnlyPolicy
implements HAPolicy<Activation> {
    private ScaleDownPolicy scaleDownPolicy;

    public PrimaryOnlyPolicy() {
    }

    public PrimaryOnlyPolicy(ScaleDownPolicy scaleDownPolicy) {
        this.scaleDownPolicy = scaleDownPolicy;
    }

    @Override
    public Activation createActivation(ActiveMQServerImpl server, boolean wasPrimary, Map<String, Object> activationParams, IOCriticalErrorListener ioCriticalErrorListener) {
        return new PrimaryOnlyActivation(server, this);
    }

    @Override
    public String getBackupGroupName() {
        return null;
    }

    @Override
    public String getScaleDownGroupName() {
        return this.scaleDownPolicy == null ? null : this.scaleDownPolicy.getGroupName();
    }

    @Override
    public String getScaleDownClustername() {
        return null;
    }

    @Override
    public int getScaleDownCommitInterval() {
        return this.scaleDownPolicy == null ? -1 : this.scaleDownPolicy.getCommitInterval();
    }

    @Override
    public boolean isSharedStore() {
        return false;
    }

    @Override
    public boolean isBackup() {
        return false;
    }

    @Override
    public boolean canScaleDown() {
        return this.scaleDownPolicy != null;
    }

    public ScaleDownPolicy getScaleDownPolicy() {
        return this.scaleDownPolicy;
    }

    public void setScaleDownPolicy(ScaleDownPolicy scaleDownPolicy) {
        this.scaleDownPolicy = scaleDownPolicy;
    }
}

