/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jgroups.Address;
import org.jgroups.EmptyMessage;
import org.jgroups.Message;
import org.jgroups.logging.Log;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Promise;

public class Leaver {
    protected final GMS gms;
    protected final Log log;
    protected final Promise<Address> leave_promise = new Promise();
    protected final AtomicBoolean leaving = new AtomicBoolean(false);

    public Leaver(GMS gms) {
        this.gms = Objects.requireNonNull(gms);
        this.log = gms.getLog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leave() {
        Address me = this.gms.getAddress();
        if (!this.leaving.compareAndSet(false, true)) {
            Address coord = this.gms.getCoord();
            if (coord == null) {
                this.log.trace("%s: last member in the group (coord); leaving now", me);
                this.leave_promise.setResult(me);
            } else {
                this.log.trace("%s: re-sending LEAVE request to %s", me, coord);
                this.sendLeaveRequest(coord, me);
            }
            return;
        }
        try {
            this.leave_promise.reset(false);
            Address coord = this.gms.getCoord();
            if (coord == null) {
                this.log.trace("%s: last member in the group (coord); leaving now", me);
                return;
            }
            this.log.trace("%s: sending LEAVE request to %s", me, coord);
            long start = System.currentTimeMillis();
            this.sendLeaveRequest(coord, me);
            if (this.leaving.get()) {
                Address sender = this.leave_promise.getResult(this.gms.leave_timeout);
                long time = System.currentTimeMillis() - start;
                if (this.leave_promise.hasResult()) {
                    if (sender != null) {
                        boolean myself = Objects.equals(sender, me);
                        this.log.trace("%s: got LEAVE response from %s in %d ms", me, myself ? " self" : sender, time);
                    } else {
                        this.log.trace("%s: timed out waiting for LEAVE response from %s (after %d ms)", me, coord, time);
                    }
                }
            }
        }
        finally {
            this.reset();
        }
    }

    public void handleLeaveResponse(Address sender) {
        this.leave_promise.setResult(Objects.requireNonNull(sender));
    }

    public void coordChanged(Address new_coord) {
        if (!this.leaving.get() || new_coord == null) {
            return;
        }
        Address leaving_mbr = this.gms.getAddress();
        if (leaving_mbr == null) {
            this.log.error("local address is null, cannot re-send LEAVE request");
        } else {
            this.log.trace("%s: re-sending LEAVE request to %s", this.gms.getAddress(), new_coord);
            this.sendLeaveRequest(new_coord, leaving_mbr);
        }
    }

    public void reset() {
        if (this.leaving.compareAndSet(true, false)) {
            this.leave_promise.setResult(null);
        }
    }

    protected void sendLeaveRequest(Address coord, Address leaving_mbr) {
        Message msg = new EmptyMessage(coord).setFlag(Message.Flag.OOB).setFlag(Message.TransientFlag.DONT_BLOCK).putHeader(this.gms.getId(), new GMS.GmsHeader(3, leaving_mbr));
        ((Protocol)this.gms.getDownProtocol()).down(msg);
    }
}

