/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.security.jaas.kubernetes.client;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Scanner;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.activemq.artemis.core.remoting.impl.ssl.SSLSupport;
import org.apache.activemq.artemis.json.JsonValue;
import org.apache.activemq.artemis.spi.core.security.jaas.kubernetes.client.KubernetesClient;
import org.apache.activemq.artemis.spi.core.security.jaas.kubernetes.model.TokenReview;
import org.apache.activemq.artemis.utils.JsonLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesClientImpl
implements KubernetesClient {
    private static final Logger logger = LoggerFactory.getLogger(KubernetesClientImpl.class);
    private static final String KUBERNETES_HOST = "KUBERNETES_SERVICE_HOST";
    private static final String KUBERNETES_PORT = "KUBERNETES_SERVICE_PORT";
    private static final String KUBERNETES_TOKEN_PATH = "KUBERNETES_TOKEN_PATH";
    private static final String KUBERNETES_CA_PATH = "KUBERNETES_CA_PATH";
    private static final String KUBERNETES_TOKENREVIEW_URI_PATTERN = "https://%s:%s/apis/authentication.k8s.io/v1/tokenreviews";
    private static final String DEFAULT_KUBERNETES_TOKEN_PATH = "/var/run/secrets/kubernetes.io/serviceaccount/token";
    private static final String DEFAULT_KUBERNETES_CA_PATH = "/var/run/secrets/kubernetes.io/serviceaccount/ca.crt";
    private URI apiUri;
    private String tokenPath = this.getParam("KUBERNETES_TOKEN_PATH", "/var/run/secrets/kubernetes.io/serviceaccount/token");
    private String caPath = this.getParam("KUBERNETES_CA_PATH", "/var/run/secrets/kubernetes.io/serviceaccount/ca.crt");

    public KubernetesClientImpl() {
        String host = this.getParam(KUBERNETES_HOST);
        String port = this.getParam(KUBERNETES_PORT);
        this.apiUri = URI.create(String.format(KUBERNETES_TOKENREVIEW_URI_PATTERN, host, port));
        logger.debug("using apiUri {}", (Object)this.apiUri);
    }

    public String getParam(String name, String defaultValue) {
        String value = System.getProperty(name);
        if (value == null) {
            value = System.getenv(name);
        }
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    private String getParam(String name) {
        return this.getParam(name, null);
    }

    @Override
    public TokenReview getTokenReview(String token) {
        SSLContext ctx;
        TokenReview tokenReview = new TokenReview();
        String authToken = null;
        try {
            logger.debug("Loading client authentication token from {}", (Object)this.tokenPath);
            authToken = this.readFile(this.tokenPath);
            logger.debug("Loaded client authentication token from {}", (Object)this.tokenPath);
        }
        catch (IOException e) {
            logger.error("Cannot retrieve Service Account Authentication Token from " + this.tokenPath, (Throwable)e);
            return tokenReview;
        }
        String jsonRequest = this.buildJsonRequest(token);
        try {
            ctx = this.buildSSLContext();
        }
        catch (Exception e) {
            logger.error("Unable to build a valid SSLContext", (Throwable)e);
            return tokenReview;
        }
        HttpClient client = HttpClient.newBuilder().sslContext(ctx).build();
        HttpRequest request = HttpRequest.newBuilder(this.apiUri).header("Authorization", "Bearer " + authToken).header("Accept", "application/json; charset=utf-8").POST(HttpRequest.BodyPublishers.ofString(jsonRequest)).build();
        logger.debug("Submit TokenReview request to Kubernetes API");
        try {
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() == 201) {
                logger.debug("Received valid TokenReview response");
                return TokenReview.fromJsonString(response.body());
            }
            logger.error("Unable to retrieve a valid TokenReview. Received StatusCode: {}. Body: {}", (Object)response.statusCode(), (Object)response.body());
        }
        catch (IOException | InterruptedException e) {
            logger.error("Unable to request ReviewToken", (Throwable)e);
        }
        return tokenReview;
    }

    private String readFile(String path) throws IOException {
        try (Scanner scanner = new Scanner(Path.of(path, new String[0]));){
            StringBuilder buffer = new StringBuilder();
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (line.isBlank() || line.startsWith("#")) continue;
                buffer.append(line);
            }
            String string = buffer.toString();
            return string;
        }
    }

    private String buildJsonRequest(String clientToken) {
        return JsonLoader.createObjectBuilder().add("apiVersion", "authentication.k8s.io/v1").add("kind", "TokenReview").add("spec", (JsonValue)JsonLoader.createObjectBuilder().add("token", clientToken).build()).build().toString();
    }

    private SSLContext buildSSLContext() throws Exception {
        SSLContext ctx = SSLContext.getInstance("SSL");
        File certFile = new File(this.caPath);
        if (!certFile.exists()) {
            logger.debug("Kubernetes CA certificate not found at: {}. Truststore not configured", (Object)this.caPath);
            return ctx;
        }
        KeyStore trustStore = SSLSupport.loadKeystore(null, (String)"PEMCA", (String)this.caPath, null);
        TrustManagerFactory tmFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmFactory.init(trustStore);
        ctx.init(null, tmFactory.getTrustManagers(), new SecureRandom());
        return ctx;
    }
}

