/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.microprofile.client;

import java.util.Comparator;
import java.util.Map;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.microprofile.client.MicroProfileClientConfigurableImpl;
import org.apache.cxf.microprofile.client.MicroProfileClientFactoryBean;

class ContractComparator
implements Comparator<ProviderInfo<?>> {
    private final MicroProfileClientFactoryBean microProfileClientFactoryBean;
    private final Comparator<ProviderInfo<?>> parent;

    ContractComparator(MicroProfileClientFactoryBean microProfileClientFactoryBean, Comparator<ProviderInfo<?>> parent) {
        this.microProfileClientFactoryBean = microProfileClientFactoryBean;
        this.parent = parent;
    }

    @Override
    public int compare(ProviderInfo<?> oLeft, ProviderInfo<?> oRight) {
        int parentResult = this.parent.compare(oLeft, oRight);
        if (parentResult != 0) {
            return parentResult;
        }
        int left = this.getPriority(oLeft.getResourceClass());
        int right = this.getPriority(oRight.getResourceClass());
        return left - right;
    }

    private int getPriority(Class<?> clazz) {
        Map contracts = this.microProfileClientFactoryBean.getConfiguration().getContracts(clazz);
        if (contracts != null && !contracts.isEmpty()) {
            for (Class<?> providerClass : MicroProfileClientConfigurableImpl.CONTRACTS) {
                Integer priority = (Integer)contracts.get(providerClass);
                if (priority == null) continue;
                return priority;
            }
        }
        return AnnotationUtils.getBindingPriority(clazz);
    }
}

