/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.io.function.IOStream;

public final class CSVPrinter
implements Flushable,
Closeable {
    private final Appendable appendable;
    private final CSVFormat format;
    private boolean newRecord = true;

    public CSVPrinter(Appendable appendable, CSVFormat format) throws IOException {
        Objects.requireNonNull(appendable, "appendable");
        Objects.requireNonNull(format, "format");
        this.appendable = appendable;
        this.format = format.copy();
        String[] headerComments = format.getHeaderComments();
        if (headerComments != null) {
            for (String line : headerComments) {
                this.printComment(line);
            }
        }
        if (format.getHeader() != null && !format.getSkipHeaderRecord()) {
            this.printRecord(format.getHeader());
        }
    }

    @Override
    public void close() throws IOException {
        this.close(false);
    }

    public void close(boolean flush) throws IOException {
        if (flush || this.format.getAutoFlush()) {
            this.flush();
        }
        if (this.appendable instanceof Closeable) {
            ((Closeable)((Object)this.appendable)).close();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.appendable instanceof Flushable) {
            ((Flushable)((Object)this.appendable)).flush();
        }
    }

    public Appendable getOut() {
        return this.appendable;
    }

    public synchronized void print(Object value) throws IOException {
        this.format.print(value, this.appendable, this.newRecord);
        this.newRecord = false;
    }

    public synchronized void printComment(String comment) throws IOException {
        if (comment == null || !this.format.isCommentMarkerSet()) {
            return;
        }
        if (!this.newRecord) {
            this.println();
        }
        this.appendable.append(this.format.getCommentMarker().charValue());
        this.appendable.append(' ');
        block4: for (int i2 = 0; i2 < comment.length(); ++i2) {
            char c = comment.charAt(i2);
            switch (c) {
                case '\r': {
                    if (i2 + 1 < comment.length() && comment.charAt(i2 + 1) == '\n') {
                        ++i2;
                    }
                }
                case '\n': {
                    this.println();
                    this.appendable.append(this.format.getCommentMarker().charValue());
                    this.appendable.append(' ');
                    continue block4;
                }
                default: {
                    this.appendable.append(c);
                }
            }
        }
        this.println();
    }

    public synchronized void printHeaders(ResultSet resultSet) throws IOException, SQLException {
        this.printRecord(this.format.builder().setHeader(resultSet).build().getHeader());
    }

    public synchronized void println() throws IOException {
        this.format.println(this.appendable);
        this.newRecord = true;
    }

    public synchronized void printRecord(Iterable<?> values) throws IOException {
        IOStream.of(values).forEachOrdered(this::print);
        this.println();
    }

    public void printRecord(Object ... values) throws IOException {
        this.printRecord(Arrays.asList(values));
    }

    public synchronized void printRecord(Stream<?> values) throws IOException {
        IOStream.adapt(values).forEachOrdered(this::print);
        this.println();
    }

    private void printRecordObject(Object value) throws IOException {
        if (value instanceof Object[]) {
            this.printRecord((Object[])value);
        } else if (value instanceof Iterable) {
            this.printRecord((Iterable)value);
        } else {
            this.printRecord(value);
        }
    }

    public void printRecords(Iterable<?> values) throws IOException {
        IOStream.of(values).forEachOrdered(this::printRecordObject);
    }

    public void printRecords(Object ... values) throws IOException {
        this.printRecords(Arrays.asList(values));
    }

    public void printRecords(ResultSet resultSet) throws SQLException, IOException {
        int columnCount = resultSet.getMetaData().getColumnCount();
        while (resultSet.next()) {
            for (int i2 = 1; i2 <= columnCount; ++i2) {
                Object object = resultSet.getObject(i2);
                if (object instanceof Clob) {
                    try (Reader reader = ((Clob)object).getCharacterStream();){
                        this.print(reader);
                        continue;
                    }
                }
                if (object instanceof Blob) {
                    try (InputStream inputStream = ((Blob)object).getBinaryStream();){
                        this.print(inputStream);
                        continue;
                    }
                }
                this.print(object);
            }
            this.println();
        }
    }

    public void printRecords(ResultSet resultSet, boolean printHeader) throws SQLException, IOException {
        if (printHeader) {
            this.printHeaders(resultSet);
        }
        this.printRecords(resultSet);
    }

    public void printRecords(Stream<?> values) throws IOException {
        IOStream.adapt(values).forEachOrdered(this::printRecordObject);
    }
}

