/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.ClassPathUtils;
import org.apache.commons.lang3.LangAssertions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ClassPathUtilsTest
extends AbstractLangTest {
    ClassPathUtilsTest() {
    }

    @Test
    void testConstructor() {
        Assertions.assertNotNull((Object)new ClassPathUtils());
        Constructor<?>[] cons = ClassPathUtils.class.getDeclaredConstructors();
        Assertions.assertEquals((int)1, (int)cons.length);
        Assertions.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assertions.assertTrue((boolean)Modifier.isPublic(ClassPathUtils.class.getModifiers()));
        Assertions.assertFalse((boolean)Modifier.isFinal(ClassPathUtils.class.getModifiers()));
    }

    @Test
    void testPackageToPath() {
        Assertions.assertEquals((Object)"a", (Object)ClassPathUtils.packageToPath((String)"a"));
        Assertions.assertEquals((Object)"a/b", (Object)ClassPathUtils.packageToPath((String)"a.b"));
        Assertions.assertEquals((Object)"a/b/c", (Object)ClassPathUtils.packageToPath((String)"a.b.c"));
    }

    @Test
    void testPathToPackage() {
        Assertions.assertEquals((Object)"a", (Object)ClassPathUtils.pathToPackage((String)"a"));
        Assertions.assertEquals((Object)"a.b", (Object)ClassPathUtils.pathToPackage((String)"a/b"));
        Assertions.assertEquals((Object)"a.b.c", (Object)ClassPathUtils.pathToPackage((String)"a/b/c"));
    }

    @Test
    void testToFullyQualifiedNameClassNull() {
        LangAssertions.assertNullPointerException(() -> ClassPathUtils.toFullyQualifiedName(ClassPathUtils.class, null));
    }

    @Test
    void testToFullyQualifiedNameClassString() {
        String expected = "org.apache.commons.lang3.Test.properties";
        String actual = ClassPathUtils.toFullyQualifiedName(ClassPathUtils.class, (String)"Test.properties");
        Assertions.assertEquals((Object)"org.apache.commons.lang3.Test.properties", (Object)actual);
    }

    @Test
    void testToFullyQualifiedNameNullClassString() {
        LangAssertions.assertNullPointerException(() -> ClassPathUtils.toFullyQualifiedName((Class)null, (String)"Test.properties"));
    }

    @Test
    void testToFullyQualifiedNameNullPackageString() {
        LangAssertions.assertNullPointerException(() -> ClassPathUtils.toFullyQualifiedName((Package)null, (String)"Test.properties"));
    }

    @Test
    void testToFullyQualifiedNamePackageNull() {
        LangAssertions.assertNullPointerException(() -> ClassPathUtils.toFullyQualifiedName((Package)ClassPathUtils.class.getPackage(), null));
    }

    @Test
    void testToFullyQualifiedNamePackageString() {
        String expected = "org.apache.commons.lang3.Test.properties";
        String actual = ClassPathUtils.toFullyQualifiedName((Package)ClassPathUtils.class.getPackage(), (String)"Test.properties");
        Assertions.assertEquals((Object)"org.apache.commons.lang3.Test.properties", (Object)actual);
    }

    @Test
    void testToFullyQualifiedPathClass() {
        String expected = "org/apache/commons/lang3/Test.properties";
        String actual = ClassPathUtils.toFullyQualifiedPath(ClassPathUtils.class, (String)"Test.properties");
        Assertions.assertEquals((Object)"org/apache/commons/lang3/Test.properties", (Object)actual);
    }

    @Test
    void testToFullyQualifiedPathClassNull() {
        LangAssertions.assertNullPointerException(() -> ClassPathUtils.toFullyQualifiedPath(ClassPathUtils.class, null));
    }

    @Test
    void testToFullyQualifiedPathClassNullString() {
        LangAssertions.assertNullPointerException(() -> ClassPathUtils.toFullyQualifiedPath((Class)null, (String)"Test.properties"));
    }

    @Test
    void testToFullyQualifiedPathPackage() {
        String expected = "org/apache/commons/lang3/Test.properties";
        String actual = ClassPathUtils.toFullyQualifiedPath((Package)ClassPathUtils.class.getPackage(), (String)"Test.properties");
        Assertions.assertEquals((Object)"org/apache/commons/lang3/Test.properties", (Object)actual);
    }

    @Test
    void testToFullyQualifiedPathPackageNull() {
        LangAssertions.assertNullPointerException(() -> ClassPathUtils.toFullyQualifiedPath((Package)ClassPathUtils.class.getPackage(), null));
    }

    @Test
    void testToFullyQualifiedPathPackageNullString() {
        LangAssertions.assertNullPointerException(() -> ClassPathUtils.toFullyQualifiedPath((Package)null, (String)"Test.properties"));
    }
}

