/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.io.IOException;
import java.sql.SQLException;
import org.apache.commons.lang3.LangAssertions;
import org.apache.commons.lang3.concurrent.AbstractConcurrentInitializer;
import org.apache.commons.lang3.concurrent.AbstractConcurrentInitializerTest;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.ConcurrentInitializer;
import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableSupplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractConcurrentInitializerCloseAndExceptionsTest<T>
extends AbstractConcurrentInitializerTest<T> {
    protected static CloseableObject methodThatThrowsException(ExceptionToThrow input) throws IOException, SQLException, ConcurrentException {
        switch (input) {
            case IOException: {
                throw new IOException();
            }
            case SQLException: {
                throw new SQLException();
            }
            case NullPointerException: {
                throw new NullPointerException();
            }
        }
        Assertions.fail();
        return new CloseableObject();
    }

    protected abstract ConcurrentInitializer<CloseableObject> createInitializerThatThrowsException(FailableSupplier<CloseableObject, ? extends Exception> var1, FailableConsumer<CloseableObject, ? extends Exception> var2);

    @Test
    void testCloserThrowsCheckedException() throws ConcurrentException {
        ConcurrentInitializer<CloseableObject> initializer = this.createInitializerThatThrowsException((FailableSupplier<CloseableObject, Exception>)((FailableSupplier)CloseableObject::new), (FailableConsumer<CloseableObject, Exception>)((FailableConsumer)CloseableObject2 -> AbstractConcurrentInitializerCloseAndExceptionsTest.methodThatThrowsException(ExceptionToThrow.IOException)));
        try {
            initializer.get();
            ((AbstractConcurrentInitializer)initializer).close();
            Assertions.fail();
        }
        catch (Exception e) {
            Assertions.assertInstanceOf(ConcurrentException.class, (Object)e);
            Assertions.assertInstanceOf(IOException.class, (Object)e.getCause());
        }
    }

    @Test
    void testCloserThrowsRuntimeException() throws ConcurrentException {
        ConcurrentInitializer<CloseableObject> initializer = this.createInitializerThatThrowsException((FailableSupplier<CloseableObject, Exception>)((FailableSupplier)CloseableObject::new), (FailableConsumer<CloseableObject, Exception>)((FailableConsumer)CloseableObject2 -> AbstractConcurrentInitializerCloseAndExceptionsTest.methodThatThrowsException(ExceptionToThrow.NullPointerException)));
        initializer.get();
        LangAssertions.assertNullPointerException(() -> ((AbstractConcurrentInitializer)initializer).close());
    }

    @Test
    void testSupplierThrowsCheckedException() {
        ConcurrentInitializer<CloseableObject> initializer = this.createInitializerThatThrowsException((FailableSupplier<CloseableObject, Exception>)((FailableSupplier)() -> AbstractConcurrentInitializerCloseAndExceptionsTest.methodThatThrowsException(ExceptionToThrow.IOException)), (FailableConsumer<CloseableObject, Exception>)FailableConsumer.NOP);
        Assertions.assertThrows(ConcurrentException.class, () -> initializer.get());
    }

    @Test
    void testSupplierThrowsConcurrentException() {
        ConcurrentException concurrentException = new ConcurrentException();
        ConcurrentInitializer<CloseableObject> initializer = this.createInitializerThatThrowsException((FailableSupplier<CloseableObject, Exception>)((FailableSupplier)() -> {
            if ("test".equals("test")) {
                throw concurrentException;
            }
            return new CloseableObject();
        }), (FailableConsumer<CloseableObject, Exception>)FailableConsumer.NOP);
        try {
            initializer.get();
            Assertions.fail();
        }
        catch (ConcurrentException e) {
            Assertions.assertEquals((Object)((Object)concurrentException), (Object)((Object)e));
        }
    }

    @Test
    void testSupplierThrowsRuntimeException() {
        ConcurrentInitializer<CloseableObject> initializer = this.createInitializerThatThrowsException((FailableSupplier<CloseableObject, Exception>)((FailableSupplier)() -> AbstractConcurrentInitializerCloseAndExceptionsTest.methodThatThrowsException(ExceptionToThrow.NullPointerException)), (FailableConsumer<CloseableObject, Exception>)FailableConsumer.NOP);
        LangAssertions.assertNullPointerException(() -> initializer.get());
    }

    @Test
    void testWorkingCloser() throws Exception {
        ConcurrentInitializer<CloseableObject> initializer = this.createInitializerThatThrowsException((FailableSupplier<CloseableObject, Exception>)((FailableSupplier)CloseableObject::new), (FailableConsumer<CloseableObject, Exception>)((FailableConsumer)CloseableObject::close));
        CloseableObject closeableObject = (CloseableObject)initializer.get();
        Assertions.assertFalse((boolean)closeableObject.isClosed());
        ((AbstractConcurrentInitializer)initializer).close();
        Assertions.assertTrue((boolean)closeableObject.isClosed());
    }

    protected static enum ExceptionToThrow {
        IOException,
        SQLException,
        NullPointerException;

    }

    protected static final class CloseableObject {
        boolean closed;

        protected CloseableObject() {
        }

        public void close() {
            this.closed = true;
        }

        public boolean isClosed() {
            return this.closed;
        }
    }
}

