/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder;

import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BasicConfigurationBuilder;
import org.apache.commons.configuration2.builder.BuilderEventListenerImpl;
import org.apache.commons.configuration2.builder.ConfigurationBuilderEvent;
import org.apache.commons.configuration2.builder.ReloadingBuilderSupportListener;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.event.EventType;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.reloading.ReloadingController;
import org.apache.commons.configuration2.reloading.ReloadingDetector;
import org.apache.commons.configuration2.reloading.ReloadingEvent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestReloadingBuilderSupportListener {
    @Test
    public void testResetBuilderOnReloadingEvent() {
        ReloadingDetector detector = (ReloadingDetector)Mockito.mock(ReloadingDetector.class);
        Mockito.when((Object)detector.isReloadingRequired()).thenReturn((Object)true);
        ReloadingController controller = new ReloadingController(detector);
        BasicConfigurationBuilder builder = new BasicConfigurationBuilder(PropertiesConfiguration.class);
        BuilderEventListenerImpl builderListener = new BuilderEventListenerImpl();
        builder.addEventListener(ConfigurationBuilderEvent.ANY, (EventListener)builderListener);
        ReloadingBuilderSupportListener listener = ReloadingBuilderSupportListener.connect((BasicConfigurationBuilder)builder, (ReloadingController)controller);
        Assertions.assertNotNull((Object)listener);
        controller.checkForReloading(null);
        builderListener.nextEvent(ConfigurationBuilderEvent.RESET);
        builderListener.assertNoMoreEvents();
    }

    @Test
    public void testResetReloadingStateOnResultCreation() throws ConfigurationException {
        ReloadingController controller = (ReloadingController)Mockito.mock(ReloadingController.class);
        BasicConfigurationBuilder builder = new BasicConfigurationBuilder(PropertiesConfiguration.class);
        ReloadingBuilderSupportListener listener = ReloadingBuilderSupportListener.connect((BasicConfigurationBuilder)builder, (ReloadingController)controller);
        Assertions.assertNotNull((Object)listener);
        builder.getConfiguration();
        ((ReloadingController)Mockito.verify((Object)controller)).addEventListener((EventType)ArgumentMatchers.eq((Object)ReloadingEvent.ANY), (EventListener)ArgumentMatchers.any());
        ((ReloadingController)Mockito.verify((Object)controller)).resetReloadingState();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{controller});
    }
}

