/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.sql.converters;

import java.sql.Time;
import java.util.Calendar;
import java.util.Locale;
import org.apache.commons.beanutils2.converters.AbstractDateConverterTest;
import org.apache.commons.beanutils2.sql.converters.SqlTimeConverter;
import org.junit.jupiter.api.Test;

public class SqlTimeConverterTest
extends AbstractDateConverterTest<Time> {
    @Override
    protected Class<Time> getExpectedType() {
        return Time.class;
    }

    protected SqlTimeConverter makeConverter() {
        return new SqlTimeConverter();
    }

    protected SqlTimeConverter makeConverter(Time defaultValue) {
        return new SqlTimeConverter(defaultValue);
    }

    @Override
    @Test
    public void testDefaultStringToTypeConvert() {
        SqlTimeConverter converter = this.makeConverter();
        converter.setUseLocaleFormat(false);
        String testString = "15:36:21";
        Object expected = this.toType("15:36:21", "HH:mm:ss", null);
        this.validConversion(converter, expected, "15:36:21");
        this.invalidConversion(converter, "15:36");
    }

    @Override
    @Test
    public void testLocale() {
        Locale defaultLocale = Locale.getDefault();
        Locale.setDefault(Locale.US);
        String pattern = "h:mm a";
        SqlTimeConverter converter = this.makeConverter();
        converter.setUseLocaleFormat(true);
        String testString = "3:06 pm";
        Object expected = this.toType("3:06 pm", "h:mm a", null);
        this.validConversion(converter, expected, "3:06 pm");
        this.invalidConversion(converter, (Object)null);
        this.invalidConversion(converter, "");
        this.invalidConversion(converter, "13:05");
        this.invalidConversion(converter, "11:05 p");
        this.invalidConversion(converter, "11.05 pm");
        this.invalidConversion(converter, 2);
        converter.setLocale(Locale.UK);
        this.invalidConversion(converter, "3:06 pm");
        this.validConversion(converter, expected, "15:06");
        Locale.setDefault(defaultLocale);
    }

    @Override
    protected Time toType(Calendar value) {
        return new Time(this.getTimeInMillis(value));
    }
}

