/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import org.apache.commons.beanutils2.BeanUtils;
import org.apache.commons.beanutils2.BeanUtilsBean;
import org.apache.commons.beanutils2.ContextClassLoaderLocal;
import org.apache.commons.beanutils2.ConvertUtils;
import org.apache.commons.beanutils2.ConvertUtilsBean;
import org.apache.commons.beanutils2.Converter;
import org.apache.commons.beanutils2.PrimitiveBean;
import org.apache.commons.beanutils2.PropertyUtilsBean;
import org.apache.commons.logging.LogFactory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BeanificationTest {
    public static final int MAX_GC_ITERATIONS = 50;

    @BeforeEach
    public void setUp() {
        ConvertUtils.deregister();
    }

    @AfterEach
    public void tearDown() {
    }

    @Test
    public void testBeanUtilsBeanSetInstance() throws Exception {
        Signal signal = new Signal();
        signal.setSignal(1);
        BeanUtilsBean beanOne = new BeanUtilsBean();
        BeanUtilsBean beanTwo = new BeanUtilsBean();
        final class SetInstanceTesterThread
        extends Thread {
            private final Signal signal;
            private final BeanUtilsBean bean;

            SetInstanceTesterThread(Signal signal, BeanUtilsBean bean) {
                this.signal = signal;
                this.bean = bean;
            }

            @Override
            public void run() {
                BeanUtilsBean.setInstance((BeanUtilsBean)this.bean);
                this.signal.setSignal(21);
                this.signal.setBean(BeanUtilsBean.getInstance());
            }

            @Override
            public String toString() {
                return "SetInstanceTesterThread";
            }
        }
        SetInstanceTesterThread thread = new SetInstanceTesterThread(signal, beanTwo);
        thread.setContextClassLoader(new TestClassLoader());
        BeanUtilsBean.setInstance((BeanUtilsBean)beanOne);
        Assertions.assertEquals((Object)beanOne, (Object)BeanUtilsBean.getInstance(), (String)"Start thread gets right instance");
        thread.start();
        thread.join();
        Assertions.assertEquals((int)21, (int)signal.getSignal(), (String)"Signal not set by test thread");
        Assertions.assertEquals((Object)beanOne, (Object)BeanUtilsBean.getInstance(), (String)"Second thread preserves value");
        Assertions.assertEquals((Object)beanTwo, (Object)signal.getBean(), (String)"Second thread gets value it set");
    }

    @Test
    public void testContextClassloaderIndependence() throws Exception {
        PrimitiveBean bean = new PrimitiveBean();
        BeanUtils.setProperty((Object)bean, (String)"int", (Object)new Integer(1));
        Assertions.assertEquals((int)1, (int)bean.getInt(), (String)"Wrong property value (1)");
        Converter c = (type, value) -> ConvertUtils.primitiveToWrapper((Class)type).cast(new Integer(5));
        ConvertUtils.register((Converter)c, Integer.TYPE);
        BeanUtils.setProperty((Object)bean, (String)"int", (Object)new Integer(1));
        Assertions.assertEquals((int)5, (int)bean.getInt(), (String)"Wrong property value(2)");
        Signal signal = new Signal();
        signal.setSignal(1);
        final class TestIndependenceThread
        extends Thread {
            private final Signal signal;
            private final PrimitiveBean bean;

            TestIndependenceThread(Signal signal, PrimitiveBean bean) {
                this.signal = signal;
                this.bean = bean;
            }

            @Override
            public void run() {
                try {
                    this.signal.setSignal(3);
                    Converter c = (type, value) -> ConvertUtils.primitiveToWrapper(Integer.TYPE).cast(new Integer(9));
                    ConvertUtils.register((Converter)c, Integer.TYPE);
                    BeanUtils.setProperty((Object)this.bean, (String)"int", (Object)new Integer(1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.signal.setException(e);
                }
            }

            @Override
            public String toString() {
                return "TestIndependenceThread";
            }
        }
        TestIndependenceThread thread = new TestIndependenceThread(signal, bean);
        thread.setContextClassLoader(new TestClassLoader());
        thread.start();
        thread.join();
        Assertions.assertNull((Object)signal.getException(), (String)("Exception thrown by test thread:" + signal.getException()));
        Assertions.assertEquals((int)3, (int)signal.getSignal(), (String)"Signal not set by test thread");
        Assertions.assertEquals((int)9, (int)bean.getInt(), (String)"Wrong property value(3)");
    }

    @Test
    public void testContextClassLoaderLocal() throws Exception {
        ContextClassLoaderLocal ccll = new ContextClassLoaderLocal();
        ccll.set((Object)new Integer(1776));
        Assertions.assertEquals((Integer)new Integer(1776), (Integer)((Integer)ccll.get()), (String)"Start thread sets value");
        Signal signal = new Signal();
        signal.setSignal(1);
        final class CCLLTesterThread
        extends Thread {
            private final Signal signal;
            private final ContextClassLoaderLocal<Integer> ccll;

            CCLLTesterThread(Signal signal, ContextClassLoaderLocal<Integer> ccll) {
                this.signal = signal;
                this.ccll = ccll;
            }

            @Override
            public void run() {
                this.ccll.set((Object)new Integer(1789));
                this.signal.setSignal(2);
                this.signal.setMarkerObject(this.ccll.get());
            }

            @Override
            public String toString() {
                return "CCLLTesterThread";
            }
        }
        CCLLTesterThread thread = new CCLLTesterThread(signal, (ContextClassLoaderLocal<Integer>)ccll);
        thread.setContextClassLoader(new TestClassLoader());
        thread.start();
        thread.join();
        Assertions.assertEquals((int)2, (int)signal.getSignal(), (String)"Signal not set by test thread");
        Assertions.assertEquals((Integer)new Integer(1776), (Integer)((Integer)ccll.get()), (String)"Second thread preserves value");
        Assertions.assertEquals((Object)new Integer(1789), (Object)signal.getMarkerObject(), (String)"Second thread gets value it set");
    }

    @Test
    public void testContextClassLoaderUnset() throws Exception {
        BeanUtilsBean beanOne = new BeanUtilsBean();
        ContextClassLoaderLocal ccll = new ContextClassLoaderLocal();
        ccll.set((Object)beanOne);
        Assertions.assertEquals((Object)beanOne, (Object)ccll.get(), (String)"Start thread gets right instance");
        ccll.unset();
        Assertions.assertNotEquals((Object)beanOne, (Object)ccll.get(), (String)"Unset works");
    }

    @Test
    public void testGetByContextClassLoader() throws Exception {
        Signal signal = new Signal();
        signal.setSignal(1);
        final class GetBeanUtilsBeanThread
        extends Thread {
            private final Signal signal;

            GetBeanUtilsBeanThread(Signal signal) {
                this.signal = signal;
            }

            @Override
            public void run() {
                this.signal.setSignal(2);
                this.signal.setBean(BeanUtilsBean.getInstance());
                this.signal.setConvertUtils(ConvertUtilsBean.getInstance());
                this.signal.setPropertyUtils(PropertyUtilsBean.getInstance());
            }

            @Override
            public String toString() {
                return "GetBeanUtilsBeanThread";
            }
        }
        GetBeanUtilsBeanThread thread = new GetBeanUtilsBeanThread(signal);
        thread.setContextClassLoader(new TestClassLoader());
        thread.start();
        thread.join();
        Assertions.assertEquals((int)2, (int)signal.getSignal(), (String)"Signal not set by test thread");
        Assertions.assertNotEquals((Object)BeanUtilsBean.getInstance(), (Object)signal.getBean(), (String)"Different BeanUtilsBean instances per context classloader");
        Assertions.assertNotEquals((Object)ConvertUtilsBean.getInstance(), (Object)signal.getConvertUtils(), (String)"Different ConvertUtilsBean instances per context classloader");
        Assertions.assertNotEquals((Object)PropertyUtilsBean.getInstance(), (Object)signal.getPropertyUtils(), (String)"Different PropertyUtilsBean instances per context classloader");
    }

    @Test
    public void testMemoryLeak() throws Exception {
        TestClassLoader loader = new TestClassLoader();
        WeakReference<TestClassLoader> loaderReference = new WeakReference<TestClassLoader>(loader);
        BeanUtilsBean.getInstance();
        final class GetBeanUtilsBeanThread
        extends Thread {
            BeanUtilsBean beanUtils;
            ConvertUtilsBean convertUtils;
            PropertyUtilsBean propertyUtils;

            GetBeanUtilsBeanThread() {
            }

            @Override
            public void run() {
                this.beanUtils = BeanUtilsBean.getInstance();
                this.convertUtils = ConvertUtilsBean.getInstance();
                this.propertyUtils = PropertyUtilsBean.getInstance();
                LogFactory.releaseAll();
            }

            @Override
            public String toString() {
                return "GetBeanUtilsBeanThread";
            }
        }
        GetBeanUtilsBeanThread thread = new GetBeanUtilsBeanThread();
        WeakReference<GetBeanUtilsBeanThread> threadWeakReference = new WeakReference<GetBeanUtilsBeanThread>(thread);
        thread.setContextClassLoader(loader);
        thread.start();
        thread.join();
        WeakReference<BeanUtilsBean> beanUtilsReference = new WeakReference<BeanUtilsBean>(thread.beanUtils);
        WeakReference<PropertyUtilsBean> propertyUtilsReference = new WeakReference<PropertyUtilsBean>(thread.propertyUtils);
        WeakReference<ConvertUtilsBean> convertUtilsReference = new WeakReference<ConvertUtilsBean>(thread.convertUtils);
        Assertions.assertNotNull(loaderReference.get(), (String)"Weak reference released early (1)");
        Assertions.assertNotNull(beanUtilsReference.get(), (String)"Weak reference released early (2)");
        Assertions.assertNotNull(propertyUtilsReference.get(), (String)"Weak reference released early (3)");
        Assertions.assertNotNull(convertUtilsReference.get(), (String)"Weak reference released early (4)");
        loader = null;
        thread.setContextClassLoader(null);
        thread = null;
        int iterations = 0;
        int bytz = 2;
        while (true) {
            BeanUtilsBean.getInstance();
            System.gc();
            Assertions.assertFalse((iterations++ > 50 ? 1 : 0) != 0, (String)"Max iterations reached before resource released.");
            if (loaderReference.get() == null && beanUtilsReference.get() == null && propertyUtilsReference.get() == null && convertUtilsReference.get() == null) break;
            byte[] b = new byte[bytz];
            bytz *= 2;
        }
    }

    @Test
    public void testMemoryLeak2() throws Exception {
        TestClassLoader loader = new TestClassLoader();
        ReferenceQueue queue = new ReferenceQueue();
        WeakReference<TestClassLoader> loaderReference = new WeakReference<TestClassLoader>(loader, queue);
        Integer test = new Integer(1);
        WeakReference<Integer> testReference = new WeakReference<Integer>(test, queue);
        WeakHashMap<TestClassLoader, Integer> map = new WeakHashMap<TestClassLoader, Integer>();
        map.put(loader, test);
        Assertions.assertEquals((Object)test, map.get(loader), (String)"In map");
        Assertions.assertNotNull(loaderReference.get(), (String)"Weak reference released early (1)");
        Assertions.assertNotNull(testReference.get(), (String)"Weak reference released early (2)");
        loader = null;
        test = null;
        int iterations = 0;
        int bytz = 2;
        while (true) {
            System.gc();
            Assertions.assertFalse((iterations++ > 50 ? 1 : 0) != 0, (String)"Max iterations reached before resource released.");
            map.isEmpty();
            if (loaderReference.get() == null && testReference.get() == null) break;
            byte[] b = new byte[bytz];
            bytz *= 2;
        }
    }

    @Test
    public void testMemoryTestMethodology() throws Exception {
        ClassLoader loader = new ClassLoader(this.getClass().getClassLoader()){};
        WeakReference<1> reference = new WeakReference<1>(loader);
        Class<?> myClass = loader.loadClass("org.apache.commons.beanutils2.BetaBean");
        Assertions.assertNotNull(reference.get(), (String)"Weak reference released early");
        loader = null;
        myClass = null;
        int iterations = 0;
        int bytz = 2;
        while (true) {
            System.gc();
            Assertions.assertFalse((iterations++ > 50 ? 1 : 0) != 0, (String)"Max iterations reached before resource released.");
            if (reference.get() == null) break;
            byte[] b = new byte[bytz];
            bytz *= 2;
        }
    }

    final class Signal {
        private Exception e;
        private int signal;
        private BeanUtilsBean bean;
        private PropertyUtilsBean propertyUtils;
        private ConvertUtilsBean convertUtils;
        private Object marker;

        Signal() {
        }

        public BeanUtilsBean getBean() {
            return this.bean;
        }

        public ConvertUtilsBean getConvertUtils() {
            return this.convertUtils;
        }

        public Exception getException() {
            return this.e;
        }

        public Object getMarkerObject() {
            return this.marker;
        }

        public PropertyUtilsBean getPropertyUtils() {
            return this.propertyUtils;
        }

        public int getSignal() {
            return this.signal;
        }

        public void setBean(BeanUtilsBean bean) {
            this.bean = bean;
        }

        public void setConvertUtils(ConvertUtilsBean convertUtils) {
            this.convertUtils = convertUtils;
        }

        public void setException(Exception e) {
            this.e = e;
        }

        public void setMarkerObject(Object marker) {
            this.marker = marker;
        }

        public void setPropertyUtils(PropertyUtilsBean propertyUtils) {
            this.propertyUtils = propertyUtils;
        }

        public void setSignal(int signal) {
            this.signal = signal;
        }
    }

    final class TestClassLoader
    extends ClassLoader {
        TestClassLoader() {
        }

        public String toString() {
            return "TestClassLoader";
        }
    }
}

