/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2;

import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DynaProperty {
    private static final int BOOLEAN_TYPE = 1;
    private static final int BYTE_TYPE = 2;
    private static final int CHAR_TYPE = 3;
    private static final int DOUBLE_TYPE = 4;
    private static final int FLOAT_TYPE = 5;
    private static final int INT_TYPE = 6;
    private static final int LONG_TYPE = 7;
    private static final int SHORT_TYPE = 8;
    public static final DynaProperty[] EMPTY_ARRAY = new DynaProperty[0];
    protected String name;
    protected transient Class<?> type;
    protected transient Class<?> contentType;

    public DynaProperty(String name) {
        this(name, Object.class);
    }

    public DynaProperty(String name, Class<?> type) {
        this.name = name;
        this.type = type;
        if (type != null && type.isArray()) {
            this.contentType = type.getComponentType();
        }
    }

    public DynaProperty(String name, Class<?> type, Class<?> contentType) {
        this.name = name;
        this.type = type;
        this.contentType = contentType;
    }

    public boolean equals(Object obj) {
        boolean result;
        boolean bl = result = obj == this;
        if (!result && obj instanceof DynaProperty) {
            DynaProperty that = (DynaProperty)obj;
            result = Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.contentType, that.contentType);
        }
        return result;
    }

    public Class<?> getContentType() {
        return this.contentType;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.type;
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.contentType == null ? 0 : this.contentType.hashCode());
        return result;
    }

    public boolean isIndexed() {
        if (this.type == null) {
            return false;
        }
        return this.type.isArray() || List.class.isAssignableFrom(this.type);
    }

    public boolean isMapped() {
        if (this.type == null) {
            return false;
        }
        return Map.class.isAssignableFrom(this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DynaProperty[name=");
        sb.append(this.name);
        sb.append(",type=");
        sb.append(this.type);
        if (this.isMapped() || this.isIndexed()) {
            sb.append(" <").append(this.contentType).append(">");
        }
        sb.append("]");
        return sb.toString();
    }
}

