/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.converters;

import org.apache.commons.beanutils2.ConversionException;
import org.apache.commons.beanutils2.Converter;
import org.apache.commons.beanutils2.converters.AbstractNumberConverterTest;
import org.apache.commons.beanutils2.converters.IntegerConverter;
import org.apache.commons.beanutils2.converters.NumberConverter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class IntegerConverterTest
extends AbstractNumberConverterTest<Integer> {
    private Converter<Integer> converter;

    @Override
    protected Class<Integer> getExpectedType() {
        return Integer.class;
    }

    @Override
    protected NumberConverter<Integer> makeConverter() {
        return new IntegerConverter();
    }

    protected IntegerConverter makeConverter(Integer defaultValue) {
        return new IntegerConverter(defaultValue);
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.converter = this.makeConverter();
        this.numbers[0] = Integer.valueOf("-12");
        this.numbers[1] = Integer.valueOf("13");
        this.numbers[2] = Integer.valueOf("-22");
        this.numbers[3] = Integer.valueOf("23");
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.converter = null;
    }

    @Test
    public void testInvalidAmount() {
        NumberConverter<Integer> converter = this.makeConverter();
        Class<Integer> clazz = Integer.class;
        Long min = Integer.MIN_VALUE;
        Long max = Integer.MAX_VALUE;
        Long minMinusOne = min - 1L;
        Long maxPlusOne = max + 1L;
        Assertions.assertEquals((Object)Integer.MIN_VALUE, (Object)converter.convert(clazz, (Object)min), (String)"Minimum");
        Assertions.assertEquals((Object)Integer.MAX_VALUE, (Object)converter.convert(clazz, (Object)max), (String)"Maximum");
        Assertions.assertThrows(ConversionException.class, () -> converter.convert(clazz, (Object)minMinusOne), (String)"Less than minimum, expected ConversionException");
        Assertions.assertThrows(ConversionException.class, () -> converter.convert(clazz, (Object)maxPlusOne), (String)"More than maximum, expected ConversionException");
    }

    @Test
    public void testInvalidDefaultObject() {
        NumberConverter<Integer> converter = this.makeConverter();
        Assertions.assertThrows(ConversionException.class, () -> converter.setDefaultValue((Object)"notANumber"), (String)"Invalid default value not detected!");
    }

    @Test
    public void testSimpleConversion() throws Exception {
        String[] message = new String[]{"from String", "from String", "from String", "from String", "from String", "from String", "from String", "from Byte", "from Short", "from Integer", "from Long", "from Float", "from Double"};
        Object[] input = new Object[]{String.valueOf(Integer.MIN_VALUE), "-17", "-1", "0", "1", "17", String.valueOf(Integer.MAX_VALUE), (byte)7, (short)8, 9, 10L, Float.valueOf(11.1f), 12.2};
        Integer[] expected = new Integer[]{Integer.MIN_VALUE, -17, -1, 0, 1, 17, Integer.MAX_VALUE, 7, 8, 9, 10, 11, 12};
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((Integer)expected[i], (Integer)((Integer)this.converter.convert(Integer.class, input[i])), (String)(message[i] + " to Integer"));
            Assertions.assertEquals((Integer)expected[i], (Integer)((Integer)this.converter.convert(Integer.TYPE, input[i])), (String)(message[i] + " to int"));
            Assertions.assertEquals((Integer)expected[i], (Integer)((Integer)this.converter.convert(null, input[i])), (String)(message[i] + " to null type"));
        }
    }
}

