/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.converters;

import java.text.DecimalFormat;
import java.util.Locale;
import org.apache.commons.beanutils2.ConversionException;
import org.apache.commons.beanutils2.converters.AbstractLocaleConverterTest;
import org.apache.commons.beanutils2.locale.LocaleConvertUtils;
import org.apache.commons.beanutils2.locale.converters.FloatLocaleConverter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FloatLocaleConverterTest
extends AbstractLocaleConverterTest<Float> {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.defaultValue = Float.valueOf("9.99");
        this.expectedValue = Float.valueOf(this.expectedDecimalValue);
    }

    @Test
    public void testConstructor_2() {
        this.converter = FloatLocaleConverter.builder().get();
        this.convertValueNoPattern(this.converter, this.defaultDecimalValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.defaultDecimalValue, this.defaultDecimalPattern, this.expectedValue);
        this.convertInvalid(this.converter, null);
        this.convertNull(this.converter, null);
    }

    @Test
    public void testConstructor_3() {
        this.converter = ((FloatLocaleConverter.Builder)FloatLocaleConverter.builder().setLocalizedPattern(true)).get();
        this.convertValueNoPattern(this.converter, this.defaultDecimalValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.defaultDecimalValue, this.defaultDecimalPattern, this.expectedValue);
        this.convertInvalid(this.converter, null);
        this.convertNull(this.converter, null);
    }

    @Test
    public void testConstructor_4() {
        this.converter = ((FloatLocaleConverter.Builder)FloatLocaleConverter.builder().setLocale(this.localizedLocale)).get();
        this.convertValueNoPattern(this.converter, this.localizedDecimalValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.localizedDecimalValue, this.defaultDecimalPattern, this.expectedValue);
        this.convertInvalid(this.converter, null);
        this.convertNull(this.converter, null);
    }

    @Test
    public void testConstructor_5() {
        this.converter = ((FloatLocaleConverter.Builder)((FloatLocaleConverter.Builder)FloatLocaleConverter.builder().setLocale(this.localizedLocale)).setLocalizedPattern(true)).get();
        this.convertValueNoPattern(this.converter, this.localizedDecimalValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.localizedDecimalValue, this.localizedDecimalPattern, this.expectedValue);
        this.convertInvalid(this.converter, null);
        this.convertNull(this.converter, null);
    }

    @Test
    public void testConstructor_6() {
        this.converter = ((FloatLocaleConverter.Builder)((FloatLocaleConverter.Builder)FloatLocaleConverter.builder().setLocale(this.localizedLocale)).setPattern(this.defaultDecimalPattern)).get();
        this.convertValueNoPattern(this.converter, this.localizedDecimalValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.localizedDecimalValue, this.defaultDecimalPattern, this.expectedValue);
        this.convertInvalid(this.converter, null);
        this.convertNull(this.converter, null);
    }

    @Test
    public void testConstructor_7() {
        this.converter = ((FloatLocaleConverter.Builder)((FloatLocaleConverter.Builder)((FloatLocaleConverter.Builder)FloatLocaleConverter.builder().setLocale(this.localizedLocale)).setPattern(this.localizedDecimalPattern)).setLocalizedPattern(true)).get();
        this.convertValueNoPattern(this.converter, this.localizedDecimalValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.localizedDecimalValue, this.localizedDecimalPattern, this.expectedValue);
        this.convertInvalid(this.converter, null);
        this.convertNull(this.converter, null);
    }

    @Test
    public void testConstructor_8() {
        this.converter = ((FloatLocaleConverter.Builder)FloatLocaleConverter.builder().setDefault((Object)((Float)this.defaultValue))).get();
        this.convertValueNoPattern(this.converter, this.defaultDecimalValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.defaultDecimalValue, this.defaultDecimalPattern, this.expectedValue);
        this.convertInvalid(this.converter, this.defaultValue);
        this.convertNull(this.converter, this.defaultValue);
    }

    @Test
    public void testConstructor_9() {
        this.converter = ((FloatLocaleConverter.Builder)((FloatLocaleConverter.Builder)FloatLocaleConverter.builder().setDefault((Object)((Float)this.defaultValue))).setLocalizedPattern(true)).get();
        this.convertValueNoPattern(this.converter, this.defaultDecimalValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.defaultDecimalValue, this.defaultDecimalPattern, this.expectedValue);
        this.convertInvalid(this.converter, this.defaultValue);
        this.convertNull(this.converter, this.defaultValue);
    }

    @Test
    public void testConstructorMain() {
        this.converter = ((FloatLocaleConverter.Builder)((FloatLocaleConverter.Builder)((FloatLocaleConverter.Builder)((FloatLocaleConverter.Builder)FloatLocaleConverter.builder().setDefault((Object)((Float)this.defaultValue))).setLocale(this.localizedLocale)).setPattern(this.localizedDecimalPattern)).setLocalizedPattern(true)).get();
        this.convertValueNoPattern(this.converter, "(A)", this.localizedDecimalValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, "(A)", this.localizedDecimalValue, this.localizedDecimalPattern, this.expectedValue);
        this.convertInvalid(this.converter, "(A)", this.defaultValue);
        this.convertNull(this.converter, "(A)", this.defaultValue);
        this.convertValueNoPattern(this.converter, "(B)", this.defaultDecimalValue, Float.valueOf("1.234"));
        this.convertValueWithPattern(this.converter, "(B)", this.localizedDecimalValue, this.defaultDecimalPattern, this.defaultValue);
        this.converter = ((FloatLocaleConverter.Builder)((FloatLocaleConverter.Builder)((FloatLocaleConverter.Builder)((FloatLocaleConverter.Builder)FloatLocaleConverter.builder().setDefault((Object)((Float)this.defaultValue))).setLocale(this.localizedLocale)).setPattern(this.defaultDecimalPattern)).setLocalizedPattern(false)).get();
        this.convertValueNoPattern(this.converter, "(C)", this.localizedDecimalValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, "(C)", this.localizedDecimalValue, this.defaultDecimalPattern, this.expectedValue);
        this.convertInvalid(this.converter, "(C)", this.defaultValue);
        this.convertNull(this.converter, "(C)", this.defaultValue);
    }

    @Test
    public void testFloatLimits() {
        this.converter = ((FloatLocaleConverter.Builder)((FloatLocaleConverter.Builder)FloatLocaleConverter.builder().setLocale(this.defaultLocale)).setPattern(this.defaultDecimalPattern)).get();
        DecimalFormat fmt = new DecimalFormat("#.#############################################################");
        Assertions.assertEquals((Object)Float.valueOf(-0.12f), (Object)this.converter.convert((Object)"-0.12"));
        Assertions.assertEquals((Object)Float.valueOf(Float.MAX_VALUE), (Object)this.converter.convert((Object)fmt.format(3.4028234663852886E38)), (String)"Positive Float.MAX_VALUE");
        Assertions.assertEquals((Object)Float.valueOf(Float.MIN_VALUE), (Object)this.converter.convert((Object)fmt.format(1.4E-45f)), (String)"Positive Float.MIN_VALUE");
        Assertions.assertEquals((Object)Float.valueOf(-3.4028235E38f), (Object)this.converter.convert((Object)fmt.format(-3.4028234663852886E38)), (String)"Negative Float.MAX_VALUE");
        Assertions.assertEquals((Object)Float.valueOf(-1.4E-45f), (Object)this.converter.convert((Object)fmt.format(-1.4E-45f)), (String)"Negative Float.MIN_VALUE");
        try {
            this.converter.convert((Object)fmt.format(3.4028234663852886E39));
            Assertions.fail((String)"Positive Too Large should throw ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.converter.convert((Object)fmt.format(-3.4028234663852886E39));
            Assertions.fail((String)"Negative Too Large should throw ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.converter.convert((Object)fmt.format(1.4012984643248171E-46));
            Assertions.fail((String)"Positive Too Small should throw ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.converter.convert((Object)fmt.format(-1.4012984643248171E-46));
            Assertions.fail((String)"Negative Too Small should throw ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }

    @Test
    public void testParseZero() {
        try {
            Object result = LocaleConvertUtils.convert((String)"0", Float.class, (Locale)Locale.US, null);
            Assertions.assertEquals((Object)Float.valueOf(0.0f), (Object)result);
        }
        catch (ConversionException e) {
            Assertions.fail((String)("Zero threw ConversionException: " + (Object)((Object)e)));
        }
    }
}

