/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.converters;

import org.apache.commons.beanutils2.ConversionException;
import org.apache.commons.beanutils2.Converter;
import org.apache.commons.beanutils2.converters.AbstractNumberConverterTest;
import org.apache.commons.beanutils2.converters.ByteConverter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ByteConverterTest
extends AbstractNumberConverterTest<Byte> {
    private Converter<Byte> converter;

    @Override
    protected Class<Byte> getExpectedType() {
        return Byte.class;
    }

    protected ByteConverter makeConverter() {
        return new ByteConverter();
    }

    protected ByteConverter makeConverter(Byte defaultValue) {
        return new ByteConverter(defaultValue);
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.converter = this.makeConverter();
        this.numbers[0] = Byte.valueOf("-12");
        this.numbers[1] = Byte.valueOf("13");
        this.numbers[2] = Byte.valueOf("-22");
        this.numbers[3] = Byte.valueOf("23");
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.converter = null;
    }

    @Test
    public void testInvalidAmount() {
        ByteConverter converter = this.makeConverter();
        Class<Byte> clazz = Byte.class;
        Long min = -128L;
        Long max = 127L;
        Long minMinusOne = min - 1L;
        Long maxPlusOne = max + 1L;
        Assertions.assertEquals((Byte)-128, (Byte)((Byte)converter.convert(clazz, (Object)min)), (String)"Minimum");
        Assertions.assertEquals((Byte)127, (Byte)((Byte)converter.convert(clazz, (Object)max)), (String)"Maximum");
        Assertions.assertThrows(ConversionException.class, () -> ByteConverterTest.lambda$testInvalidAmount$0((Converter)converter, clazz, minMinusOne), (String)"Less than minimum, expected ConversionException");
        Assertions.assertThrows(ConversionException.class, () -> ByteConverterTest.lambda$testInvalidAmount$1((Converter)converter, clazz, maxPlusOne), (String)"More than maximum, expected ConversionException");
    }

    @Test
    public void testSimpleConversion() throws Exception {
        String[] message = new String[]{"from String", "from String", "from String", "from String", "from String", "from String", "from String", "from Byte", "from Short", "from Integer", "from Long", "from Float", "from Double"};
        Object[] input = new Object[]{String.valueOf(-128), "-17", "-1", "0", "1", "17", String.valueOf(127), (byte)7, (short)8, 9, 10L, Float.valueOf(11.1f), 12.2};
        Byte[] expected = new Byte[]{(byte)-128, (byte)-17, (byte)-1, (byte)0, (byte)1, (byte)17, (byte)127, (byte)7, (byte)8, (byte)9, (byte)10, (byte)11, (byte)12};
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((Byte)expected[i], (Byte)((Byte)this.converter.convert(Byte.class, input[i])), (String)(message[i] + " to Byte"));
            Assertions.assertEquals((Byte)expected[i], (Byte)((Byte)this.converter.convert(Byte.TYPE, input[i])), (String)(message[i] + " to byte"));
            Assertions.assertEquals((Byte)expected[i], (Byte)((Byte)this.converter.convert(null, input[i])), (String)(message[i] + " to null type"));
        }
    }

    private static /* synthetic */ void lambda$testInvalidAmount$1(Converter converter, Class clazz, Long maxPlusOne) throws Throwable {
        converter.convert(clazz, (Object)maxPlusOne);
    }

    private static /* synthetic */ void lambda$testInvalidAmount$0(Converter converter, Class clazz, Long minMinusOne) throws Throwable {
        converter.convert(clazz, (Object)minMinusOne);
    }
}

