/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.event.ProcedureParameterEvent;
import org.apache.cayenne.dbsync.naming.NameBuilder;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.event.ProcedureParameterDisplayEvent;
import org.apache.cayenne.modeler.undo.CreateProcedureParameterUndoableEdit;
import org.apache.cayenne.modeler.util.CayenneAction;

public class CreateProcedureParameterAction
extends CayenneAction {
    public CreateProcedureParameterAction(Application application) {
        super(CreateProcedureParameterAction.getActionName(), application);
    }

    public static String getActionName() {
        return "Create Parameter";
    }

    static void fireProcedureParameterEvent(Object src, ProjectController mediator, Procedure procedure, ProcedureParameter parameter) {
        mediator.fireProcedureParameterEvent(new ProcedureParameterEvent(src, parameter, 2));
        mediator.fireProcedureParameterDisplayEvent(new ProcedureParameterDisplayEvent(src, parameter, procedure, mediator.getCurrentDataMap(), (DataChannelDescriptor)mediator.getProject().getRootNode()));
    }

    @Override
    public String getIconName() {
        return "icon-plus.png";
    }

    @Override
    public void performAction(ActionEvent e) {
        ProjectController mediator = this.getProjectController();
        if (this.getProjectController().getCurrentProcedure() != null) {
            Procedure procedure = this.getProjectController().getCurrentProcedure();
            ProcedureParameter parameter = new ProcedureParameter();
            parameter.setName(NameBuilder.builder(parameter, procedure).name());
            this.createProcedureParameter(procedure, parameter);
            this.application.getUndoManager().addEdit(new CreateProcedureParameterUndoableEdit((DataChannelDescriptor)mediator.getProject().getRootNode(), mediator.getCurrentDataMap(), procedure, parameter));
        }
    }

    public void createProcedureParameter(Procedure procedure, ProcedureParameter parameter) {
        procedure.addCallParameter(parameter);
        ProjectController mediator = this.getProjectController();
        CreateProcedureParameterAction.fireProcedureParameterEvent(this, mediator, procedure, parameter);
    }

    @Override
    public boolean enableForPath(ConfigurationNode object) {
        if (object == null) {
            return false;
        }
        return ((ProcedureParameter)object).getProcedure() != null;
    }
}

