/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Meter;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.DefaultNameFactory;

public class DenylistMetrics {
    private final Meter writesRejected;
    private final Meter readsRejected;
    private final Meter rangeReadsRejected;
    private final Meter totalRequestsRejected;

    public DenylistMetrics() {
        DefaultNameFactory factory = new DefaultNameFactory("StorageProxy", "PartitionDenylist");
        this.writesRejected = CassandraMetricsRegistry.Metrics.meter(factory.createMetricName("WriteRejected"));
        this.readsRejected = CassandraMetricsRegistry.Metrics.meter(factory.createMetricName("ReadRejected"));
        this.rangeReadsRejected = CassandraMetricsRegistry.Metrics.meter(factory.createMetricName("RangeReadRejected"));
        this.totalRequestsRejected = CassandraMetricsRegistry.Metrics.meter(factory.createMetricName("TotalRejected"));
    }

    public void incrementWritesRejected() {
        this.writesRejected.mark();
        this.totalRequestsRejected.mark();
    }

    public void incrementReadsRejected() {
        this.readsRejected.mark();
        this.totalRequestsRejected.mark();
    }

    public void incrementRangeReadsRejected() {
        this.rangeReadsRejected.mark();
        this.totalRequestsRejected.mark();
    }
}

