/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.Collection;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.io.sstable.AbstractSSTableSimpleWriter;
import org.apache.cassandra.io.sstable.SSTableTxnWriter;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.schema.TableMetadataRef;

class SSTableSimpleWriter
extends AbstractSSTableSimpleWriter {
    private final long maxSSTableSizeInBytes;
    protected DecoratedKey currentKey;
    protected PartitionUpdate.Builder update;
    private SSTableTxnWriter writer;

    protected SSTableSimpleWriter(File directory, TableMetadataRef metadata, RegularAndStaticColumns columns, long maxSSTableSizeInMiB) {
        super(directory, metadata, columns);
        this.maxSSTableSizeInBytes = maxSSTableSizeInMiB * 1024L * 1024L;
    }

    @Override
    PartitionUpdate.Builder getUpdateFor(DecoratedKey key) throws IOException {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Partition update cannot have null key");
        if (this.update == null || !key.equals(this.currentKey)) {
            if (this.update != null) {
                this.writePartition(this.update.build());
            }
            this.currentKey = key;
            this.update = new PartitionUpdate.Builder(this.metadata.get(), this.currentKey, this.columns, 4);
        }
        Preconditions.checkState((this.update != null ? 1 : 0) != 0, (Object)"Partition update to write cannot be null");
        return this.update;
    }

    @Override
    public void close() {
        this.writeLastPartitionUpdate(this.update);
        this.maybeCloseWriter(this.writer);
    }

    private boolean shouldSwitchToNewWriter() {
        return this.writer == null || this.maxSSTableSizeInBytes > 0L && this.writer.getOnDiskBytesWritten() > this.maxSSTableSizeInBytes;
    }

    private SSTableTxnWriter getOrCreateWriter() throws IOException {
        if (this.shouldSwitchToNewWriter()) {
            this.maybeCloseWriter(this.writer);
            this.writer = this.createWriter();
        }
        return this.writer;
    }

    private void writeLastPartitionUpdate(PartitionUpdate.Builder update) {
        try {
            if (update != null) {
                this.writePartition(update.build());
            }
        }
        catch (Throwable t) {
            Throwable e = this.writer == null ? t : this.writer.abort(t);
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void maybeCloseWriter(SSTableTxnWriter writer) {
        try {
            if (writer == null) {
                return;
            }
            Collection<SSTableReader> finished = writer.finish(this.shouldOpenSSTables());
            this.notifySSTableProduced(finished);
        }
        catch (Throwable t) {
            Throwable e = writer.abort(t);
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void writePartition(PartitionUpdate update) throws IOException {
        this.getOrCreateWriter().append(update.unfilteredIterator());
    }
}

