/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import inet.ipaddr.IPAddressNetwork;
import inet.ipaddr.IPAddressString;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class SubnetGroups {
    public Set<Group> subnets = Collections.emptySet();

    public SubnetGroups() {
    }

    public SubnetGroups(List<String> values) {
        this.subnets = ImmutableSet.copyOf((Collection)values.stream().map(Group::new).collect(Collectors.toSet()));
    }

    public boolean contains(SocketAddress address) {
        Preconditions.checkNotNull((Object)address);
        Preconditions.checkArgument((boolean)(address instanceof InetSocketAddress), (Object)("Unsupported socket address type: " + address.getClass()));
        return this.contains(((InetSocketAddress)address).getAddress());
    }

    public boolean contains(InetAddress address) {
        for (Group group : this.subnets) {
            if (!group.contains(address)) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.subnets.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubnetGroups that = (SubnetGroups)o;
        return this.subnets.equals(that.subnets);
    }

    public int hashCode() {
        return Objects.hash(this.subnets);
    }

    public String toString() {
        return "SubnetGroups{subnets=" + this.subnets + '}';
    }

    private static class Group {
        private static final IPAddressNetwork.IPAddressGenerator IP_ADDRESS_GENERATOR = new IPAddressNetwork.IPAddressGenerator();
        private final IPAddressString subnet;

        Group(String range) {
            this.subnet = new IPAddressString(range);
        }

        boolean contains(InetAddress address) {
            return this.subnet.contains(IP_ADDRESS_GENERATOR.from(address).toAddressString());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Group group = (Group)o;
            return this.subnet.equals((Object)group.subnet);
        }

        public int hashCode() {
            return Objects.hash(this.subnet);
        }

        public String toString() {
            return this.subnet.toString();
        }
    }
}

