/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.event;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.gridkit.jvmtool.stacktrace.CounterCollection;

public class SimpleCounterCollection
implements CounterCollection {
    private Map<String, Long> counters = new TreeMap<String, Long>();

    @Override
    public Iterator<String> iterator() {
        return this.counters.keySet().iterator();
    }

    @Override
    public long getValue(String key) {
        Long n = this.counters.get(key);
        return n == null ? Long.MIN_VALUE : n;
    }

    public void set(String key, long value) {
        this.counters.put(key, value);
    }

    public void setAll(CounterCollection that) {
        for (String key : that) {
            this.set(key, that.getValue(key));
        }
    }

    @Override
    public SimpleCounterCollection clone() {
        try {
            SimpleCounterCollection that = (SimpleCounterCollection)super.clone();
            that.counters = new TreeMap<String, Long>(this.counters);
            return that;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void clear() {
        this.counters.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (String key : this) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append(key).append(": ").append(this.getValue(key));
        }
        sb.append(']');
        return sb.toString();
    }
}

