/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.fqltool;

import java.util.PriorityQueue;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.wire.ReadMarshallable;
import org.apache.cassandra.fqltool.FQLQuery;
import org.apache.cassandra.fqltool.FQLQueryReader;
import org.apache.cassandra.utils.AbstractIterator;

public class FQLQueryIterator
extends AbstractIterator<FQLQuery> {
    private final PriorityQueue<FQLQuery> pq;
    private final ExcerptTailer tailer;
    private final FQLQueryReader reader;

    public FQLQueryIterator(ExcerptTailer tailer, int readAhead) {
        FQLQuery next;
        assert (readAhead > 0) : "readAhead needs to be > 0";
        this.reader = new FQLQueryReader();
        this.tailer = tailer;
        this.pq = new PriorityQueue(readAhead);
        for (int i = 0; i < readAhead && (next = this.readNext()) != null; ++i) {
            this.pq.add(next);
        }
    }

    protected FQLQuery computeNext() {
        FQLQuery q = this.pq.poll();
        if (q == null) {
            return (FQLQuery)this.endOfData();
        }
        FQLQuery next = this.readNext();
        if (next != null) {
            this.pq.add(next);
        }
        return q;
    }

    private FQLQuery readNext() {
        if (this.tailer.readDocument((ReadMarshallable)this.reader)) {
            return this.reader.getQuery();
        }
        return null;
    }
}

