/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.settings;

import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.stress.settings.SettingsColumn;
import org.apache.cassandra.stress.settings.SettingsErrors;
import org.apache.cassandra.stress.settings.SettingsGraph;
import org.apache.cassandra.stress.settings.SettingsInsert;
import org.apache.cassandra.stress.settings.SettingsLog;
import org.apache.cassandra.stress.settings.SettingsMode;
import org.apache.cassandra.stress.settings.SettingsNode;
import org.apache.cassandra.stress.settings.SettingsPopulation;
import org.apache.cassandra.stress.settings.SettingsPort;
import org.apache.cassandra.stress.settings.SettingsRate;
import org.apache.cassandra.stress.settings.SettingsSchema;
import org.apache.cassandra.stress.settings.SettingsTokenRange;
import org.apache.cassandra.stress.settings.SettingsTransport;

public enum CliOption {
    POP("Population distribution and intra-partition visit order", SettingsPopulation.helpPrinter()),
    INSERT("Insert specific options relating to various methods for batching and splitting partition updates", SettingsInsert.helpPrinter()),
    COL("Column details such as size and count distribution, data generator, names, comparator and if super columns should be used", SettingsColumn.helpPrinter()),
    RATE("Thread count, rate limit or automatic mode (default is auto)", SettingsRate.helpPrinter()),
    MODE("CQL mode options", SettingsMode.helpPrinter()),
    ERRORS("How to handle errors when encountered during stress", SettingsErrors.helpPrinter()),
    SCHEMA("Replication settings, compression, compaction, etc.", SettingsSchema.helpPrinter()),
    NODE("Nodes to connect to", SettingsNode.helpPrinter()),
    LOG("Where to log progress to, and the interval at which to do it", SettingsLog.helpPrinter()),
    TRANSPORT("Custom transport factories", SettingsTransport.helpPrinter()),
    PORT("The port to connect to cassandra nodes on", SettingsPort.helpPrinter()),
    GRAPH("-graph", "Graph recorded metrics", SettingsGraph.helpPrinter()),
    TOKENRANGE("Token range settings", SettingsTokenRange.helpPrinter());

    private static final Map<String, CliOption> LOOKUP;
    public final String extraName;
    public final String description;
    private final Runnable helpPrinter;

    public static CliOption get(String command) {
        return LOOKUP.get(command.toLowerCase());
    }

    private CliOption(String description, Runnable helpPrinter) {
        this(null, description, helpPrinter);
    }

    private CliOption(String extraName, String description, Runnable helpPrinter) {
        this.extraName = extraName;
        this.description = description;
        this.helpPrinter = helpPrinter;
    }

    public void printHelp() {
        this.helpPrinter.run();
    }

    static {
        HashMap<String, CliOption> lookup = new HashMap<String, CliOption>();
        for (CliOption cmd : CliOption.values()) {
            lookup.put("-" + cmd.toString().toLowerCase(), cmd);
            if (cmd.extraName == null) continue;
            lookup.put(cmd.extraName, cmd);
        }
        LOOKUP = lookup;
    }
}

