/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.algo.sequence.rmq;

import java.util.Comparator;
import org.psjava.algo.sequence.rmq.RangeMinimumQuery;
import org.psjava.algo.sequence.rmq.RangeMinimumQuerySession;
import org.psjava.algo.sequence.rmq.RangeMinimumQueryUtil;
import org.psjava.ds.array.Array;
import org.psjava.util.AssertStatus;
import org.psjava.util.FromTo;

public class OnDemandRangeMinimumQuery {
    public static RangeMinimumQuery getInstance() {
        return new RangeMinimumQuery(){

            @Override
            public <T> RangeMinimumQuerySession preprocess(final Array<T> array, final Comparator<T> comp) {
                return new RangeMinimumQuerySession(){

                    @Override
                    public int getIndex(int start, int end) {
                        AssertStatus.assertTrue(start < end);
                        int r = start;
                        for (int i : FromTo.get(start + 1, end)) {
                            r = RangeMinimumQueryUtil.selectSmallestIndex(array, r, i, comp);
                        }
                        return r;
                    }
                };
            }
        };
    }

    private OnDemandRangeMinimumQuery() {
    }
}

