/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.quarkus.component.http.vertx;

import io.vertx.core.VertxOptions;
import io.vertx.ext.web.client.spi.CookieStore;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Produces;

@ApplicationScoped
public class VertxClientRelatedBeansProducer {

    @Singleton
    @Produces
    @Named("myVertxOptions")
    VertxOptions createOptions() {
        // Setting an inconsistent value to generate an IllegalArgumentException on first Vertx.x HTTP client request
        return new VertxOptions().setMaxEventLoopExecuteTime(0);
    }

    @ApplicationScoped
    @Produces
    @Named("myVertxCookieStore")
    CookieStore createCookieStore() {
        return CookieStore.build();
    }

}
